﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components.Lieferanten
{
    public partial class LieferantenBestellungenSuche : IDisposable, IHasPageFilter
    {
        public LieferantenBestellungenFilter Filter { get; set; } = new LieferantenBestellungenFilter();
        private CancellationTokenSource cancellationToken = new CancellationTokenSource();
        private List<Bestellung> suchergebnisse = new List<Bestellung>();

        private bool sperre = false;
        private int seite = 1;

        public LieferantenFilter FilterLieferanten { get; set; } = new LieferantenFilter();

        [Parameter] public int Lieferantennummer { get; set; }

        protected override async Task OnParametersSetAsync()
        {
            if (Lieferantennummer > 0)
            {
                FilterLieferanten.Suchbegriff = Lieferantennummer.ToString();
                Filter.Lieferantennummer = Lieferantennummer;
                await Suchen();
            }
        }
        private async Task Suchen()
        {
            sperre = true;
            await Task.Run(async () =>
            {
                cancellationToken.Cancel();
                suchergebnisse.Clear();

                TotalItems = await lieferantenService.GetAnzahlLieferantenBestellungenAsync(Filter);

                if (Seite > TotalItems)
                {
                    Seite = 1;
                }

                cancellationToken = new CancellationTokenSource();

                Filter.Seite = Seite;

                await foreach (var bestellung in lieferantenService.SucheLieferantenBestellungenAsync(Filter, cancellationToken.Token))
                {
                    if (bestellung != null)
                    {
                        suchergebnisse.Add(bestellung);
                        await InvokeAsync(StateHasChanged);
                    }
                }
            });

            sperre = false;
        }

        public int TotalItems { get; set; }
        public int Seite { get => seite; set => seite = value <= 0 ? 1 : value; }
        public async Task SeiteChanged(int seite)
        {
            Seite = seite;
            await Suchen();
        }
        public void Dispose()
        {
            cancellationToken.Cancel();
        }
    }
}
