﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components.Lieferanten
{
    public partial class LieferantenArtikelSuche : IDisposable, IHasPageFilter
    {
        public LieferantenArtikelFilter Filter { get; set; } = new LieferantenArtikelFilter();
        private CancellationTokenSource cancellationToken = new CancellationTokenSource();
        private List<Lieferantenartikel> suchergebnisse = new List<Lieferantenartikel>();
        private int seite = 1;

        public LieferantenFilter FilterLieferanten { get; set; } = new LieferantenFilter();
        [Parameter] public int Lieferantennummer { get; set; }

        

        private bool sperre { get; set; } = false;

        public async Task Suchen()
        {
            sperre = true;
            cancellationToken.Cancel();
            suchergebnisse.Clear();

            TotalItems = await lieferantenService.GetAnzahlLieferantenArtikelAsync(Filter);

            if (Seite > TotalItems)
            {
                Seite = 1;
            }

            cancellationToken = new CancellationTokenSource();
            Filter.Seite = Seite;
            await foreach (var artikel in lieferantenService.SucheLieferantenArtikelAsync(Filter, cancellationToken.Token))
            {
                if (artikel != null)
                {
                    suchergebnisse.Add(artikel);
                    StateHasChanged();
                }
            }


            sperre = false;
        }

        protected override async Task OnParametersSetAsync()
        {
            if (Lieferantennummer > 0)
            {
                FilterLieferanten.Suchbegriff = Lieferantennummer.ToString();
                Filter.Lieferantennummer = Lieferantennummer;
            }
            await Suchen();
        }

        public int TotalItems { get; set; }
        public int Seite { get => seite; set => seite = value <= 0 ? 1 : value; }
        public async Task SeiteChanged(int seite)
        {
            Seite = seite;
            await Suchen();
        }

        public void Dispose()
        {
            cancellationToken.Cancel();
        }
    }
}
