﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Services;

namespace WK5_Blazor.Components
{
    public partial class KundenSeriennummern : IAsyncDisposable
    {
        [Parameter] public string Kundennummer { get; set; } = string.Empty;
        public List<ArtikelSNVerlauf> Ergebnis { get; set; } = new List<ArtikelSNVerlauf>();
        public List<ArtikelSNVerlauf> ShowErgebnis { get; set; } = new List<ArtikelSNVerlauf>();
        public bool IsLoading { get; set; } = false;

        private string _search  = String.Empty;
        private CancellationTokenSource _cts = new();
        private bool _isSortedAscending;
        private string? _activeSortColumn;
        private string _sortIcon = "arrow-down";
        protected override async Task OnParametersSetAsync()
        {
            await Suchen();
        }
        private async Task Suchen()
        {
            IsLoading = true;
            
            Ergebnis.Clear();

            _cts.Cancel();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            await foreach (ArtikelSNVerlauf result in artikelService.GetKundenSNVerlauf(Kundennummer, token))
            {
                Ergebnis.Add(result);
                StateHasChanged();
            }

            await FilterResults();

            IsLoading = false;
        }
        private Task FilterResults()
        {
            IsLoading = true;
            StateHasChanged();
            ShowErgebnis.Clear();

            _search = _search.Trim();

            foreach (ArtikelSNVerlauf verlauf in Ergebnis)
            {
                if (verlauf.Seriennummer.Contains(_search) || String.IsNullOrWhiteSpace(_search))
                {
                    ShowErgebnis.Add(verlauf);
                    StateHasChanged();
                }
            }

            _isSortedAscending = !_isSortedAscending;
            if (!String.IsNullOrWhiteSpace(_activeSortColumn))
            {
                SortTable(_activeSortColumn);
            }

            IsLoading = false;
            return Task.CompletedTask;
        }
        private void SortTable(string columnName)
        {
            if (columnName != _activeSortColumn)
            {
                ShowErgebnis = ShowErgebnis.OrderBy(x => x.GetType().GetProperty(columnName)!.GetValue(x, null)).ToList();
                _isSortedAscending = true;
                _activeSortColumn = columnName;
            }
            else
            {
                if (_isSortedAscending)
                {
                    ShowErgebnis = ShowErgebnis.OrderByDescending(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                else
                {
                    ShowErgebnis = ShowErgebnis.OrderBy(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                _isSortedAscending = !_isSortedAscending;
            }

            _sortIcon = _isSortedAscending ? "fas fa-arrow-up" : "fas fa-arrow-down";
        }
        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
