﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;
using WK5.Core.Validators;
using WK5.Core.Validators.Stammdaten.Kunden;
using WK5.Core.Basis.Filter;

namespace WK5_Blazor.Components
{
    public partial class KundenRabatteÜbersicht
    {
        [Parameter] public string Kundennummer { get; set; } = String.Empty;
        [Parameter] public List<KundenrabattInput> Kundenrabatte { get; set; } = new List<KundenrabattInput>();
        [Parameter] public bool Loading { get; set; } = false;

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private KundenrabattInput? _selectedKundenrabatt { get; set; } = null;

        private bool _showDeleteModal;


        public StaffelpreisCollectionValidator staffelValidator { get; set; } = new StaffelpreisCollectionValidator();
        private KundenrabattInputValidator _inputValidator { get; set; } = new KundenrabattInputValidator(new StaffelpreisCollectionValidator());

        public ArtikelFilter FilterArtikel { get; set; } = new ArtikelFilter();
        private EditForm? _editForm { get; set; }

        private bool _showArtikelSucheModal = false;

        private Task KundenrabattSelectedAsync(KundenrabattInput kusa)
        {
            _selectedKundenrabatt = kusa;
            return Task.CompletedTask;
        }

        private Task AddKundenrabattAsync()
        {
            var kusa = new KundenrabattInput(true, String.Empty)
            {
                Kundennummer = Kundennummer
            };

            _selectedKundenrabatt = kusa;

            _showArtikelSucheModal = true;

            return Task.CompletedTask;
        }

        private async Task RemoveKundenrabattAsync()
        {
            if (_selectedKundenrabatt is null)
            {
                return;
            }

            if (!_selectedKundenrabatt.IstNeu)
            {
                using FbController2 fbController = new FbController2();
                await kundenService.DeleteKundensachnummerAsync(_selectedKundenrabatt.Artikelnummer, _selectedKundenrabatt.Kundennummer, fbController);
            }

            Kundenrabatte.Remove(_selectedKundenrabatt);
            await jsRuntime.ShowToast(ToastType.success, "Kundensachnummer erfolgreich gelöscht.");
            _selectedKundenrabatt = null;
        }



        public async Task SaveAsync()
        {
            if (_selectedKundenrabatt is null || _editForm is null || _editForm.EditContext is null)
            {
                return;
            }

            if (!_editForm.EditContext.Validate())
            {
                return;
            }

            _selectedKundenrabatt.SortStaffelpreise();


            using FbController2 fbController = new FbController2();
            if (_selectedKundenrabatt.IstNeu)
            {
                await kundenService.CreateKundensachnummerAsync(_selectedKundenrabatt, fbController, Mitarbeiter.PersonalNummer);
                _selectedKundenrabatt.IstNeu = false;
                Kundenrabatte.Add(_selectedKundenrabatt);
                await jsRuntime.ShowToast(ToastType.success, "Kundensachnummer erfolgreich angelegt.");
            }
            else
            {
                await kundenService.UpdateKundensachnummerAsync(_selectedKundenrabatt, fbController, Mitarbeiter.PersonalNummer);
                await jsRuntime.ShowToast(ToastType.success, "Kundensachnummer erfolgreich aktualisiert.");
            }
        }

        private Task ArtikelSelectedAsync(Artikel artikel)
        {
            if (_selectedKundenrabatt is not null)
            {
                _selectedKundenrabatt.Artikelnummer = artikel.Artikelnummer;
                _selectedKundenrabatt.Artikelpreis = artikel.ARTI_N_VK1;
            }

            return Task.CompletedTask;
        }

    }
}