﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;
using WK5_Blazor.CoreExtensions;

namespace WK5_Blazor.Components
{
    public partial class KundenKontakte : IAsyncDisposable
    {
        [Parameter] public string Kundennummer { get; set; } = String.Empty;
        [Parameter] public string Belegtyp { get; set; } = string.Empty;
        [Parameter] public int Belegnummer { get; set; }
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private Kundenkontakt? _selectedKundenKontakt;
        private CancellationTokenSource _cts = new CancellationTokenSource();
        public int TotalItems { get; set; }
        // 28.07.2022 - MK: Filtereinstellungen sind Anweisung von Ley
        public KundenkontaktFilter Filter { get; set; } = new KundenkontaktFilter
        {
            ErledigteAnzeigen = true, 
            ZeitraumBegrenzen = true,
            Bis = DateTime.Now,
            Von = DateTime.Now.AddMonths(-6)
        };
        public List<Kundenkontakt> Kontakte { get; set; } = new();
        private bool _lädt;
        protected override async Task OnParametersSetAsync()
        {
            Filter.Kundennummer = Kundennummer;
            Filter.Belegtyp = Belegtyp;
            Filter.Belegnummer = Belegnummer;
            await LadeAsync();
        }
        private async Task LadeAsync(int seite = 1)
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            Kontakte.Clear();
            _lädt = true;
            using FbController2 fbController = new FbController2();
            Filter.Seite = seite;
            var token = _cts.Token;

            await foreach (var kontakt in kundenkontaktService.GetAsync(Filter, fbController, token))
            {
                Kontakte.Add(kontakt);
                StateHasChanged();
            }

            TotalItems = await kundenkontaktService.GetTotalAmountAsync(Filter, fbController, token);


            _lädt = false;
        }
        private string GetDisplayClass(Kundenkontakt kontakt)
        {
            if (kontakt.KUKO_L_WIEDERV_ERL)
            {
                return "table-success";
            }

            return string.Empty;
        }
        private async Task SaveAsync(Kundenkontakt input)
        {
            Kontakte.Insert(0, input);
            _selectedKundenKontakt = null;
            await jsRuntime.ShowToast(ToastType.success, "Kundenkontakt wurde angelegt.");
        }

        private async Task EditAsync(Kundenkontakt input)
        {
            _selectedKundenKontakt = null;
            await jsRuntime.ShowToast(ToastType.success, "Kundenkontakt wurde geändert.");
        }

        private async Task DeleteAsync(Kundenkontakt input)
        {
            Kontakte.Remove(input);
            _selectedKundenKontakt = null;
            await jsRuntime.ShowToast(ToastType.success, "Kundenkontakt wurde gelöscht.");
        }

        public Task AddKundenKontakt()
        {
            DateTime currentDateTime = DateTime.Now;
            
            DateTime wiedervorlageDateTime = currentDateTime.AddDays(7);
            _selectedKundenKontakt = new Kundenkontakt
            {
                KUKO_A_KUNDNR = Kundennummer,
                KUKO_N_WIEDERV_USER = Mitarbeiter.PersonalNummer,
                KUKO_D_DATE = currentDateTime,
                KUKO_T_TIME = currentDateTime,
                KUKO_D_WIEDERV_DATE = wiedervorlageDateTime,
                KUKO_T_WIEDERV_TIME = wiedervorlageDateTime,
                KUKO_N_BELEGNR = Belegnummer,
                KUKO_A_BELEGTYP = Belegtyp
            };

            StateHasChanged();
            return Task.CompletedTask;
        }


        private Task CancelAsync()
        {
            _selectedKundenKontakt = null;
            return Task.CompletedTask;
        }
        public async Task FinishKontakt(Kundenkontakt kontakt)
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            kontakt.KUKO_L_WIEDERV_ERL = true;
            await kundenkontaktService.UpdateAsync(kontakt, fbController);
            StateHasChanged();
        }

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
