﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class KundenArtikelHistorie : IHasPageFilter, IAsyncDisposable
    {
        private int _seite = 1;
        private bool _showSucheArtikelModal;
        public CancellationTokenSource _cts = new();
        [Parameter] public string Kundennummer { get; set; } = String.Empty;
        [Parameter] public EventCallback<WK5.Core.Models.KundenArtikelHistorie> OnÜbernahmeNachKundensachnummer { get; set; }
        [Parameter] public bool ZeigeAktionen { get; set; } = false;

        public KundenArtikelHistorieFilter Filter { get; set; } = new KundenArtikelHistorieFilter();
        public int Seite
        {
            get => _seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _seite = value;
            }
        }
        public int TotalItems { get; set; }
        public List<WK5.Core.Models.KundenArtikelHistorie> Übersicht { get; set; } = new List<WK5.Core.Models.KundenArtikelHistorie>();
        protected override async Task OnParametersSetAsync()
        {
            Filter.Limit = 100;
            Filter.Belegtyp = BelegTyp.Rechnung;

            await LadeÜbersicht();
        }
        private Task ArtikelSelectedAsync(Artikel artikel)
        {
            Filter.Artikelnummer = artikel.Artikelnummer;
            _showSucheArtikelModal = false;
            return Task.CompletedTask;
        }
        public async Task LadeÜbersicht()
        {
            Filter.Kundennummer = Kundennummer;
            Übersicht.Clear();
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();

            Filter.Seite = Seite;
            var token = _cts.Token;

            TotalItems = await kundenService.GetKundenArtikelHistorieCountAsync(Filter, token);
            await foreach (var übersicht in kundenService.GetKundenArtikelHistorieAsync(Filter, token))
            {
                Übersicht.Add(übersicht);
                StateHasChanged();
            }
        }

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
