﻿using Microsoft.AspNetCore.Components;
using System;

namespace WK5_Blazor.Components
{



    public partial class EventPagination
    {
        [Parameter] public EventCallback<int> SeiteChanged { get; set; }

        private void OnSeiteChanged(int e)
        {
            if (!Locked)
            {
                SeiteChanged.InvokeAsync(e);
            }
        }

        [Parameter] public int CurrentPageNumber { get; set; } = 1;
        [Parameter] public int ItemsProSeite { get; set; } = 30;
        [Parameter] public int TotalItems { get; set; }

        [Parameter] public bool ShowMisc { get; set; } = false;

        [Parameter] public bool Locked { get; set; } = false;

        private int AmountLeftRightOfCurrent = 2;



        public int Seitenanzahl
        {
            get
            {
                if (TotalItems == 0 || ItemsProSeite == 0)
                {
                    return 1;
                }

                return (int)Math.Ceiling((double)TotalItems / (double)ItemsProSeite);
            }
        }

        public int StartPage
        {
            get
            {
                int startPage = CurrentPageNumber - AmountLeftRightOfCurrent;
                if (startPage < 1)
                {
                    startPage = 1;
                }

                return startPage;
            }
        }

        public int MaxPage
        {
            get
            {
                int maxPage = StartPage + (AmountLeftRightOfCurrent * 2);

                if (maxPage > Seitenanzahl)
                {
                    maxPage = Seitenanzahl;
                }

                return maxPage;
            }
        }


    }
}
