﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class DokumentenablageComponent : IAsyncDisposable
    {
        [Parameter] public DokumentenablageArt Art { get; set; }
        [Parameter] public string Zuordnung { get; set; } = String.Empty;

        private List<Ablagedokument> _dokumente = new List<Ablagedokument>();
        private bool _isLoading = false;
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private Ablagedokument? _löschItem;

        string dropClass = string.Empty;
        private void HandleDragEnter()
        {
            dropClass = "dropAreaDrug";
        }
        private void HandleDragLeave()
        {
            dropClass = string.Empty;
        }
        protected override async Task OnParametersSetAsync()
        {
            await LoadDokumentenablageAsync();
        }

        private async Task OnInputFileChange(InputFileChangeEventArgs e)
        {
            dropClass = string.Empty;
            FileInfo file = await Dokumentenablage.UploadFileAsync(Art, Zuordnung, e.File);
            _dokumente.Insert(0, new Ablagedokument(file));
            await jsRuntime.ShowToast(ToastType.success, $"Dokument {file.Name} wurde erfolgreich hochgeladen");
        }
        private async Task DownloadAsync(Ablagedokument file)
        {
            file.IsDownloading = true;
            await downloadService.DownloadFile($"{file.FileInfo.Name}", await File.ReadAllBytesAsync(file.FileInfo.FullName), "application/octet-stream");
            await downloadService.ClearBuffers();
            file.IsDownloading = false;
        }

        private async Task DeleteAsync()
        {
            if(_löschItem is null)
            {
                return;
            }

            File.Delete(_löschItem.FileInfo.FullName);
            await jsRuntime.ShowToast(ToastType.success, $"Dokument {_löschItem.FileInfo.Name} wurde erfolgreich gelöscht.");
            _dokumente.Remove(_löschItem);
            _löschItem = null;
        }
        private Task LoadDokumentenablageAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            _dokumente.Clear();
            _isLoading = true;

            var token = _cts.Token;

            foreach (var file in Dokumentenablage.GetDokumentenablage(Art, Zuordnung, token))
            {
                if (_cts.IsCancellationRequested)
                {
                    break;
                }
                _dokumente.Add(file);
            }
            _isLoading = false;
            return Task.CompletedTask;
        }

  

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
