﻿using Microsoft.AspNetCore.Components;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class ChargenSuche
    {
        private readonly List<Charge> _suchergebnisse = new List<Charge>();
        [Parameter] public ChargenFilter Filter { get; set; } = new ChargenFilter();

        private CancellationTokenSource _cts = new CancellationTokenSource();

        [Parameter] public EventCallback<Charge> ChargeSelected { get; set; }
        [Parameter] public EventCallback<Charge> ChargeClicked { get; set; }
        protected override async Task OnParametersSetAsync()
        {
            await SuchenAsync();
        }
        private async Task SuchenAsync()
        {
            _cts.Cancel();
            _suchergebnisse.Clear();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            using FbController2 fbController = new FbController2();
            await foreach (var charge in chargenService.SucheChargenAsync(Filter, fbController, token))
            {
                _suchergebnisse.Add(charge);
                StateHasChanged();
            }
        }
    }
}
