﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class BestellungenSuche : IAsyncDisposable
    {
        [Parameter] public BestellungFilter Filter { get; set; } = new BestellungFilter();
        /// <summary>
        /// Wird ausgelöst, wenn der User auf eine Bestellung geklickt hat.
        /// </summary>
        [Parameter] public EventCallback<Bestellung> OnBestellungClick { get; set; }
        /// <summary>
        /// Wird ausgelöst, wenn der User eine Bestellung ausgewählt hat (Doppelklick).
        /// </summary>
        [Parameter] public EventCallback<Bestellung> OnBestellungSelected { get; set; }
        [Parameter] public bool ShowLieferantName { get; set; } = true;
        /// <summary>
        /// Gibt an, dass bereits ausgewählte Bestellungen erneut angezeigt werden sollen, oder nicht.
        /// </summary>
        [Parameter] public bool ShowSelectedAgain { get; set; } = true;

        private CancellationTokenSource _cts = new CancellationTokenSource();
        private List<Bestellung> Suchergebnisse { get; } = new List<Bestellung>();
        private Bestellung? SelectedBestellung { get; set; }



        protected override async Task OnInitializedAsync()
        {
            await Suchen();
        }

        

        public async Task Suchen()
        {
            _cts.Cancel();
            _cts = new CancellationTokenSource();
            Suchergebnisse.Clear();
            
            var token = _cts.Token;

            using FbController2 fbController = new FbController2();

            try
            {
                int totalBestellungen = await bestellService.GetAnzahlBestellungenAsync(Filter, fbController, token);
                Filter.Limit = totalBestellungen;
                await foreach (var bestellung in bestellService.GetBestellungenAsync(Filter, fbController, token))
                {
                    Suchergebnisse.Add(bestellung);
                    StateHasChanged();
                }
            }
            catch (OperationCanceledException) { }

        }

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
