﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class ArtikelSuche : IAsyncDisposable
    {
        [Parameter] public EventCallback<Artikel> OnArtikelSelected { get; set; }
        [Parameter] public EventCallback<Artikel> OnArtikelClick { get; set; }
        [Parameter] public ArtikelFilter Filter { get; set; } = new ArtikelFilter();

        private readonly List<ArtikelÜbersicht> suchergebnisse = new List<ArtikelÜbersicht>();

        private CancellationTokenSource _cancellationToken = new CancellationTokenSource();

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private Guid _id;

        public ArtikelSuche()
        {
            _id = Guid.NewGuid();
        }

        protected override async Task OnAfterRenderAsync(bool firstRender)
        {
            if (!firstRender)
            {
                await jsRuntime.FocusByIdAsync($"artikel-suche-{_id}");
            }
        }

        private async Task Suchen()
        {
            suchergebnisse.Clear();
            _cancellationToken.Cancel();
            _cancellationToken = new CancellationTokenSource();
            var token = _cancellationToken.Token;
            try
            {
                await foreach (var artikel in artikelService.GetArtikelÜbersichtAsync(Filter, token))
                {
                    suchergebnisse.Add(artikel);
                    StateHasChanged();
                }
            }
            catch (OperationCanceledException){ }
            
        }

        protected override async Task OnInitializedAsync()
        {
            await Suchen();
        }

        private async Task OnArtikelClickHandler(ArtikelÜbersicht übersicht)
        {
            using FbController2 fbController = new FbController2();
            Artikel? artikel = await artikelService.GetAsync(übersicht.ARTU_A_NR, fbController);

            if (artikel is not null)
            {
                await OnArtikelClick.InvokeAsync(artikel);
            }
        }

        private async Task OnArtikelSelectedHandler(ArtikelÜbersicht übersicht)
        {
            using FbController2 fbController = new FbController2();
            Artikel? artikel = await artikelService.GetAsync(übersicht.ARTU_A_NR, fbController);

            if (artikel is not null)
            {
                await OnArtikelSelected.InvokeAsync(artikel);
            }
        }

        public ValueTask DisposeAsync()
        {
            _cancellationToken?.Cancel();
            _cancellationToken?.Dispose();

            return ValueTask.CompletedTask;
        }
    }
}
