﻿using Microsoft.AspNetCore.Components;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Validators.Stammdaten.Artikeldaten;

namespace WK5_Blazor.Components
{
    public partial class ArtikelBundle
    {
        [Parameter] public Artikel? Input { get; set; }

        public Artikel? SelectedBundleArtikel { get; set; }

        private bool _showArtikelSuche;


        private BundleArtikelValidator _validator = new();

        private string GetRowClass(Artikel artikel)
        {
            if(!_validator.Validate(artikel).IsValid)
            {
                return "table-danger";
            }

            if (artikel.BUNDLE_N_SORT <= 0)
            {
                return "table-secondary";
            }



            return string.Empty;
        }

        private async Task ArtikelSelectedAsync(Artikel artikel)
        {
            if (Input is not null)
            {
                // Prüfen, ob wir den Artikel dem Bundle hinzufügen dürfen
                if (artikel.Artikelnummer == Input.Artikelnummer)
                {
                    await jsRuntime.ShowToast(ToastType.error, "Das Bundle kann sich nicht selber enthalten.");
                    return;
                }

                if (artikel.IstBundle)
                {
                    await jsRuntime.ShowToast(ToastType.error, "Ein Bundle kann nicht zu einem anderen Bundle hinzugefügt werden.");
                    return;
                }

                Artikel? artikelInBundle = Input.BundleArtikel.FirstOrDefault(x => x.Artikelnummer == artikel.Artikelnummer);

                if (artikelInBundle is not null)
                {
                    await jsRuntime.ShowToast(ToastType.error, "Dieser Artikel ist bereits im Bundle enthalten. Bitte passen Sie stattdessen die Menge an.");
                    SelectedBundleArtikel = artikelInBundle;
                    _showArtikelSuche = false;
                    return;
                }

                Input.BundleArtikel.Add(artikel);
                SelectedBundleArtikel = artikel;
                _showArtikelSuche = false;

                Input.IstBundle = Input.BundleArtikel.Any();
                
                if(Input.IstBundle)
                {
                    Input.ARTI_L_LAGERFUEHR = false;
                    Input.ARTI_L_SN = false;
                    Input.ARTI_L_SN_ABGANG = false;
                }
            }
        }

        private Task RemoveAsync()
        {
            if (SelectedBundleArtikel is not null && Input is not null)
            {
                Input.BundleArtikel.Remove(SelectedBundleArtikel);
                Input.IstBundle = Input.BundleArtikel.Any();
                SelectedBundleArtikel = null;
            }

            return Task.CompletedTask;
        }
    }
}
