﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Services;

namespace WK5_Blazor.Components
{
    public partial class ArtikelBelegübersicht : IHasPageFilter, IDisposable
    {
        [Parameter] public ArtikelBelegübersichtFilter Filter { get; set; } = new ArtikelBelegübersichtFilter();
        private bool _showSucheArtikelModal;
        public int TotalItems { get; set; }
        private int _Seite = 1;
        public int Seite
        {
            get => _Seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _Seite = value;
            }
        }

        public bool IsLoading { get; set; } = false;
        private async Task ArtikelSelectedAsync(Artikel artikel)
        {
            Filter.Suchbegriff = artikel.Artikelnummer;
            _showSucheArtikelModal = false;
            await Suchen();
        }
        public CancellationTokenSource CancellationToken { get; set; } = new CancellationTokenSource();
        public List<ArtikelBelegpositionenÜbersicht> Ergebnis { get; set; } = new List<ArtikelBelegpositionenÜbersicht>();
        private Dictionary<BelegTyp, List<int>> _subBelege = new Dictionary<BelegTyp, List<int>>();
        private async Task Suchen()
        {
            IsLoading = true;
            StateHasChanged();
            Ergebnis.Clear();
            TotalItems = await artikelService.GetAnzahlArtikelBelegpositionen(Filter);

            Filter.Seite = Seite;
            CancellationToken.Cancel();
            CancellationToken = new CancellationTokenSource();

            await foreach (var result in artikelService.SucheArtikelBelegpositionen(Filter, CancellationToken.Token))
            {
                Ergebnis.Add(result);
                StateHasChanged();
            }

            IsLoading = false;
        }

        private async Task SeiteChanged(int page)
        {
            Seite = page;
            await Suchen();
        }

        private ArtikelBelegpositionenÜbersicht? SelectedÜbersicht { get; set; }
        private Beleg? SelectedBeleg { get; set; }

        private async Task SelectÜbersicht(ArtikelBelegpositionenÜbersicht selected)
        {
            if (SelectedÜbersicht == selected)
            {
                SelectedÜbersicht = null;
                SelectedBeleg = null;
                _subBelege.Clear();
            }
            else
            {
                SelectedÜbersicht = selected;
                using FbController2 fbController = new FbController2();

                SelectedBeleg = await Beleg.GetBelegAsync(EnumHelper.GetBelegTyp(selected.Typ), selected.Belegnummer, fbController);
                _subBelege = await belegService.GetSubBelege(EnumHelper.GetBelegTyp(selected.Typ), selected.Belegnummer, fbController);
            }
        }

        protected override async Task OnParametersSetAsync()
        {
            await Suchen();
        }

        public void Dispose()
        {
            CancellationToken?.Cancel();
        }
    }
}
