﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.PageModels.Stammdaten.Kunden;
using System.Threading;
using WK5.Core.Basis;
using WK5.Core.Validators.Stammdaten.Kunden;
using Microsoft.JSInterop;
using WK5.Core.Basis.Erweiterungen;
using KarleyLibrary.Erweiterungen;

namespace WK5_Blazor.Components
{
    public partial class AnsprechpartnerComponent
    {
        [Parameter] public List<AnsprechpartnerInput> Partner { get; set; } = new List<AnsprechpartnerInput>();
        [Parameter] public string Kundennummer { get; set; } = String.Empty;
        [Parameter] public bool Lädt { get; set; }
        private AnsprechpartnerInput? StartCopy { get; set; }

#nullable disable
        [CascadingParameter] private AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable


        private bool _showDeleteModal = false;
        private bool _showTelefonnummerModal = false;
        private string _modalTelefonnummer = String.Empty;
        private AnsprechpartnerInput? _selectedAnsprechpartner;
        private AnsprechpartnerInputValidator _partnerValidator = new AnsprechpartnerInputValidator();

        protected override Task OnParametersSetAsync()
        {
            SortPartner();
            return Task.CompletedTask;
        }
        public Task AddAnsprechpartnerAsync()
        {
            AnsprechpartnerInput input = new AnsprechpartnerInput()
            {
                Kundennummer = Kundennummer
            };

            _selectedAnsprechpartner = input;
            StartCopy = input.DeepCopy();
            SortPartner();
            StateHasChanged();
            return Task.CompletedTask;
        }
        private async Task SaveAsync()
        {
            if (_selectedAnsprechpartner is null)
            {
                return;
            }

            if (_selectedAnsprechpartner.Nummer < 0)
            {
                _selectedAnsprechpartner.Nummer = (await WK5.Core.Models.Ansprechpartner.CreateAnsprechpartnerAsync(_selectedAnsprechpartner.ToAnsprechpartner(), Mitarbeiter.PersonalNummer)).PART_N_NR;
                await JSRuntime.ShowToast(ToastType.success, "Ansprechpartner erfolgreich angelegt.");
                Partner.Add(_selectedAnsprechpartner);
            }
            else
            {
                await WK5.Core.Models.Ansprechpartner.UpdateAnsprechpartnerAsync(_selectedAnsprechpartner.ToAnsprechpartner(), Mitarbeiter.PersonalNummer);
                await JSRuntime.ShowToast(ToastType.success, "Ansprechpartner erfolgreich aktualisiert.");
            }
            _selectedAnsprechpartner = null;
            StartCopy = null;
            StateHasChanged();
        }
        private async Task DeleteAsync()
        {
            if (_selectedAnsprechpartner is null || String.IsNullOrWhiteSpace(_selectedAnsprechpartner.Kundennummer))
            {
                return;
            }

            await WK5.Core.Models.Ansprechpartner.DeleteAnsprechpartnerAsync(_selectedAnsprechpartner.Kundennummer, _selectedAnsprechpartner.Nummer, Mitarbeiter.PersonalNummer);
            Partner.Remove(_selectedAnsprechpartner);
            _selectedAnsprechpartner = null;
            StartCopy = null;
            StateHasChanged();
        }
        private Task CancelAsync()
        {
            _selectedAnsprechpartner = null;
            StartCopy = null;
            return Task.CompletedTask;
        }
        public Task Call(string? number)
        {
            if (number is not null)
            {

                _modalTelefonnummer = number;
                _showTelefonnummerModal = true;
                StateHasChanged();
            }
            return Task.CompletedTask;
        }
        public Task SelectPartner(AnsprechpartnerInput partner)
        {
            StartCopy = partner.DeepCopy();
            _selectedAnsprechpartner = partner;
            return Task.CompletedTask;
        }
        private void SortPartner()
        {
            Partner = Partner.OrderByDescending(x => x.Hauptansprechpartner).ThenBy(x => x.Vorname).ToList();
        }
    }
}
