﻿using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Email;
using WK5.Core.Models;
using WK5.Core.Models.Tools.AdressReminder;
using WK5.Core.Services;

namespace WK5_Blazor.Components
{
    public partial class AdressReminder : IAsyncDisposable
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
        [Inject] public IJSRuntime jsRuntime { get; set; }
        [Inject] public AdressReminderService adressReminderService { get; set; }
#nullable enable
        private CancellationTokenSource _kundenKontakteCTS { get; set; } = new CancellationTokenSource();
        private List<AdressReminderOutput> Reminder { get; set; } = new List<AdressReminderOutput>();

        public ValueTask DisposeAsync()
        {
            _kundenKontakteCTS.Cancel();
            _kundenKontakteCTS.Dispose();
            return ValueTask.CompletedTask;
        }

        protected override async Task OnParametersSetAsync()
        {
#if DEBUG
            Reminder = await LadeDaten(0, 3).ToListAsync();
#else
            Reminder = await LadeDaten(Mitarbeiter.PersonalNummer, 3).ToListAsync();
#endif
        }

        private IAsyncEnumerable<AdressReminderOutput> LadeDaten(int vertreter, int months)
        {
            _kundenKontakteCTS.Cancel();
            _kundenKontakteCTS.Dispose();
            _kundenKontakteCTS = new CancellationTokenSource();
            var token = _kundenKontakteCTS.Token;

            return adressReminderService.GetReminder(vertreter, months, token);
        }

        private async Task EmailSenden(AdressReminderOutput output)
        {
            if (output.LetztesAngebot is null)
            {
                await jsRuntime.ShowToast(ToastType.error, "Email kann nicht versendet werden, es wurde kein Angebot gefunden!", 0);
                return;
            }

            KarleyBrowserInterfaceEmail? email = await adressReminderService.GetEmailText(output);
            if (email is null)
            {
                await jsRuntime.ShowToast(ToastType.error, "Email kann nicht versendet werden, der Emailtext konnte nicht generiert werden!", 0);
                return;
            }

            var (success, data, _) = KarleyLibrary.Serialization.XMLWriter.Serialize(email);
            if (success)
            {
                string xmlFilename = $"{email.GetHashCode()}.xml";
                await File.WriteAllTextAsync(Path.Combine(GlobalConfig.Configuration.OutputPfad, xmlFilename), data);
                await jsRuntime.OpenNewTab($"karley:davidMail;{xmlFilename}");
            }

            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            KundenkontaktService kundenkontaktService = new KundenkontaktService();
            Kundenkontakt kontakt = new Kundenkontakt
            {
                KUKO_A_KUNDNR = output.Kunde.KUND_A_NR,
                KUKO_D_DATE = DateTime.Now,
                KUKO_T_TIME = DateTime.Now,
                KUKO_N_ART = 99,
                KUKO_A_NOTIZ = "REMINDER"
            };


            await kundenkontaktService.CreateAsync(kontakt, fbController);
        }
    }
}
