﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;
using WK5.Core.PageModels.Admin.Hilfsdaten;
using WK5.Core.Services;

namespace WK5_Blazor
{
    public class AppDaten
    {
        //Als Listen programmiert, nur einmal geladen - spart Ladezeit .. wenn , dann hier neue Listen hinzufügen, die überall verfügbar sind.
        public List<Personal> Mitarbeiter { get; set; }
        public List<Vertreter> MitarbeiterVertreter { get; set; }
        public List<Selektionsmerkmal> SelektionsmerkmaleLieferanten { get; set; }
        public List<Selektionsmerkmal> SelektionsmerkmaleKunden { get; set; }
        public List<Selektionsmerkmal> SelektionsmerkmaleArtikel { get; set; }
        public List<Land> Länder { get; set; }
        public List<Anrede> Anreden { get; set; }
        public List<Lieferbedingung> Lieferbedingungen { get; set; }
        public ZahlungsbedingungCollection Zahlungsbedingungen { get; set; }
        public List<Kundengruppe> Kundengruppen { get; set; }
        public List<Preisliste> Preislisten { get; set; }
        public List<Währung> Währungen { get; set; }
        public List<Mehrwertsteuer> Mehrwertsteuern { get; set; }
        public List<Lagerplatz> Lagerplätze { get; set; }
        public List<Masseinheit> Masseinheiten { get; set; }
        public List<Preisgruppe> Preisgruppen { get; set; }

        public List<Kostenstelle> Kostenstellen { get; set; }

        public List<Erlöskonto> Erlöskonten { get; set; }

        public List<LieferzeitText> LieferzeitTexte { get; set; }

        public List<Rabattbezeichnung> Rabattbezeichnungen { get; set; }
        public OptionCollection Optionen { get; set; }
        public bool LiveShopDisabled { get; set; }
        public bool UseB2cFeatures { get; set; }
        public Mehrwertsteuer? VersandMehrwertsteuer { get; set; }
        public List<Gruppe> WK5Gruppen { get; set; }

        public StornierTemplateCollection StornierTemplates { get; set; }

        public List<ProvisionSatz> ProvisionsSätze { get; set; }
        public List<Belegtext> Belegtexte { get; set; }

        public List<Warengruppe> Warengruppen { get; set; }
        public List<Unterwarengruppe> Unterwarengruppen { get; set; }

        public List<Ablehnungsgrund> Ablehnungsgründe { get; set; }
        public List<Artikeltyp> Artikeltypen { get; set; }
        public List<ArtikelOption> ArtikelOptionen { get; set; }
        public List<AnsprechpartnerFunktion> AnsprechpartnerFunktionen { get; set; } 

#nullable disable
        private AppDaten()
        {

        }
#nullable enable
        public static async Task<AppDaten> CreateAsync()
        {
            using FbController2 fbController = new FbController2();
            BelegtextService belegtextService = new BelegtextService();
            ArtikeltypService artikeltypService = new ArtikeltypService();
            ArtikelOptionenService artikelOptionenService = new ArtikelOptionenService();
            return new AppDaten()
            {
                Mitarbeiter = await Personal.GetAllPersonalAsync().ToListAsync(),
                MitarbeiterVertreter = await Vertreter.GetAllVertreterAsync(fbController).ToListAsync(),
                SelektionsmerkmaleLieferanten = await Selektionsmerkmal.GetSelektionsmerkmaleAsync(SelektionsMerkmalTyp.Lieferant, fbController).ToListAsync(),
                SelektionsmerkmaleKunden = await Selektionsmerkmal.GetSelektionsmerkmaleAsync(SelektionsMerkmalTyp.Kunde, fbController).ToListAsync(),
                SelektionsmerkmaleArtikel = await Selektionsmerkmal.GetSelektionsmerkmaleAsync(SelektionsMerkmalTyp.Artikel, fbController).ToListAsync(),
                Länder = await Land.GetLänderAsync(fbController).ToListAsync(),
                Anreden = await Anrede.GetAnredenAsync(fbController).ToListAsync(),
                Lieferbedingungen = await Lieferbedingung.GetLieferbedingungenAsync().ToListAsync(),
                Zahlungsbedingungen = await Zahlungsbedingung.GetZahlungsbedingungenAsync(fbController),
                Preislisten = await Preisliste.GetPreislistenAsync(fbController).ToListAsync(),
                Kundengruppen = await Kundengruppe.GetKundengruppenAsync(fbController).ToListAsync(),
                Währungen = await Währung.GetWährungenAsync(fbController).ToListAsync(),
                Mehrwertsteuern = await Mehrwertsteuer.GetMehrwertsteuernAsync(fbController).ToListAsync(),
                Lagerplätze = await Lagerplatz.GetAllLagerAsync(fbController).ToListAsync(),
                Masseinheiten = await Masseinheit.GetMasseinheitenAsync(fbController).ToListAsync(),
                Preisgruppen = await Preisgruppe.GetPreisgruppenAsync(fbController).ToListAsync(),
                Kostenstellen = await Kostenstelle.GetKostenstellenAsync(fbController).ToListAsync(),
                Erlöskonten = await Erlöskonto.GetErlöskontenAsync(fbController).ToListAsync(),
                LiveShopDisabled = await GlobalConfig.GetConfigAsync(GlobalConfig.WK5_LIVESHOP_DISABLED_CONFIG_NAME, fbController) == "Y",
                LieferzeitTexte = await LieferzeitText.GetLieferzeitTexteAsync(fbController).ToListAsync(),
                Rabattbezeichnungen = await Rabattbezeichnung.GetRabattbezeichnungenAsync(fbController).ToListAsync(),
                Optionen = await Option.GetOptionenAsync(fbController),
                VersandMehrwertsteuer = await Mehrwertsteuer.GetVersandMehrwertsteuerAsync(fbController),
                UseB2cFeatures = await GlobalConfig.GetConfigAsync(GlobalConfig.ENABLE_B2C_CONFIG_NAME, fbController) == "Y",
                WK5Gruppen = await Gruppe.GetAllGruppenAsync(fbController).ToListAsync(),
                StornierTemplates = await StornierTemplate.GetTemplatesAsync(fbController),
                ProvisionsSätze = await ProvisionSatz.GetProvisionsSätzeAsync(fbController).ToListAsync(),
                Belegtexte = await belegtextService.GetAllAsync(fbController).ToListAsync(),
                Warengruppen = await Warengruppe.GetWarengruppenAsync(fbController).ToListAsync(),
                Unterwarengruppen = await Unterwarengruppe.GetUnterwarengruppenAsync(fbController).ToListAsync(),
                Ablehnungsgründe = await Ablehnungsgrund.GetAblehnungsgründeAsync(fbController).ToListAsync(),
                Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync(),
                ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync(),
                AnsprechpartnerFunktionen = await AnsprechpartnerFunktion.GetAnsprechpartnerFunktionenAsync(fbController)
            };


        }

        public string GetZahlungsbedingungText(int zahlungsbedingungId)
        {
            Zahlungsbedingung? zahlungsbedingung = Zahlungsbedingungen[zahlungsbedingungId];
            return zahlungsbedingung is null ? "Unbekannt" : zahlungsbedingung.ZABD_A_TEXT1;
        }

        public string GetLieferbedingungText(int lieferbedingungId)
        {
            Lieferbedingung? lieferbedingung = Lieferbedingungen.Where(x => x.LIBD_N_NR == lieferbedingungId).FirstOrDefault();
            return lieferbedingung is null ? "Unbekannt" : lieferbedingung.LIBD_A_TEXT1;
        }

        public string GetVertreterName(int vertreterId)
        {
            Vertreter? vertreter = MitarbeiterVertreter.Where(x => x.VERT_N_NR == vertreterId).FirstOrDefault();
            return vertreter is null ? "Unbekannt" : vertreter.VERT_A_NAME ?? String.Empty;
        }

        public string GetKundengruppeText(int kundengruppenId)
        {
            Kundengruppe? kundengruppe = Kundengruppen.Where(x => x.KUGR_N_NR == kundengruppenId).FirstOrDefault();
            return kundengruppe is null ? "Unbekannt" : kundengruppe.KUGR_A_BEZEICH;
        }

        public string GetMitarbeiterName(int personalNummer)
        {
            Personal? personal = Mitarbeiter.Where(x => x.PERS_N_NR == personalNummer).FirstOrDefault();

            return personal is null ? "Unbekannt" : $"{personal.PERS_A_VORNAME} {personal.PERS_A_NAME}".Trim();
        }

        
    }
}
