﻿import Sigpad from "./sigpad.min.js"

export function setup(id, reference, options, image) {
    var identifier = "signature-" + id;
    var element = document.getElementById(identifier);

    element.addEventListener("sigpad.finish", function (e) {
        reference.invokeMethodAsync('SignatureDataChangedAsync', e.detail);
    });

    var sigpad = Sigpad.getOrCreateInstance(element, JSON.parse(options));
    sigpad.setImage(image);
}

export function destroy(id) {
    var identifier = "signature-" + id;
    var element = document.getElementById(identifier);

    var sigpad = Sigpad.getInstance(element);
    if (sigpad != null) {
        sigpad.destroy();
    }
}

export function update(id,options) {
    var identifier = "signature-" + id;
    var element = document.getElementById(identifier);

    var sigpad = Sigpad.getOrCreateInstance(element, JSON.parse(options));
    sigpad._config = sigpad._getConfig(JSON.parse(options));
    sigpad._applyOptions();
}

export function updateImage(id, image) {
    var identifier = "signature-" + id;
    var element = document.getElementById(identifier);

    var sigpad = Sigpad.getInstance(element);
    if (sigpad != null) {
        sigpad.setImage(image);        
    }
}
export function clear(id) {
    var identifier = "signature-" + id;
    var element = document.getElementById(identifier);

    var sigpad = Sigpad.getInstance(element);
    if (sigpad != null) {
        sigpad.clear();
    }
}
