 export function setup(dotNetReference, image) {
     window.requestAnimFrame = (function (callback) {
         return window.requestAnimationFrame ||
             window.webkitRequestAnimationFrame ||
             window.mozRequestAnimationFrame ||
             window.oRequestAnimationFrame ||
             window.msRequestAnimaitonFrame ||
             function (callback) {
                 window.setTimeout(callback, 1000 / 60);
             };
     })();

     var canvas = document.getElementById("sig-canvas");
     canvas.width = canvas.clientWidth;
     var ctx = canvas.getContext("2d");
     ctx.strokeStyle = "#222222";
     ctx.lineWidth = 1;

     if (!isEmptyOrSpaces(image)) {         
            var img = new Image();
            img.src = image;
            img.onload = function () {
                ctx.drawImage(img, 0, 0);
            }
        }

     var drawing = false;
     var mousePos = {
         x: 0,
         y: 0
     };
     var lastPos = mousePos;

     canvas.addEventListener("mousedown", function (e) {
         drawing = true;
         lastPos = getMousePos(canvas, e);
     }, false);

     canvas.addEventListener("mouseup", function (e) {
         drawing = false;
         console.log(dotNetReference);
         dotNetReference.invokeMethodAsync('SignatureDataChangedAsync', canvas.toDataURL());
     }, false);

     canvas.addEventListener("mousemove", function (e) {
         mousePos = getMousePos(canvas, e);
     }, false);

     // Add touch event support for mobile
     canvas.addEventListener("touchstart", function (e) {
         e.preventDefault();
     }, false);

     canvas.addEventListener("touchmove", function (e) {
         e.preventDefault();
         var touch = e.touches[0];
         var me = new MouseEvent("mousemove", {
             clientX: touch.clientX,
             clientY: touch.clientY
         });
         canvas.dispatchEvent(me);

     }, false);

     canvas.addEventListener("touchstart", function (e) {
         e.preventDefault();
         mousePos = getTouchPos(canvas, e);
         var touch = e.touches[0];
         var me = new MouseEvent("mousedown", {
             clientX: touch.clientX,
             clientY: touch.clientY
         });
         canvas.dispatchEvent(me);
     }, false);

     canvas.addEventListener("touchend", function (e) {
         e.preventDefault();
         var me = new MouseEvent("mouseup", {});
         canvas.dispatchEvent(me);
     }, false);

     function getMousePos(canvasDom, mouseEvent) {
         var rect = canvasDom.getBoundingClientRect();
         return {
             x: mouseEvent.clientX - rect.left,
             y: mouseEvent.clientY - rect.top
         }
     }

     function getTouchPos(canvasDom, touchEvent) {
         var rect = canvasDom.getBoundingClientRect();
         return {
             x: touchEvent.touches[0].clientX - rect.left,
             y: touchEvent.touches[0].clientY - rect.top
         }
     }

     function renderCanvas() {
         if (drawing) {
             ctx.moveTo(lastPos.x, lastPos.y);
             ctx.lineTo(mousePos.x, mousePos.y);
             ctx.stroke();
             lastPos = mousePos;
         }
     }

     // Prevent scrolling when touching the canvas
     document.body.addEventListener("touchstart", function (e) {
         if (e.target == canvas) {
             e.preventDefault();
         }
     }, false);
     document.body.addEventListener("touchend", function (e) {
         if (e.target == canvas) {
             e.preventDefault();
         }
     }, false);
     document.body.addEventListener("touchmove", function (e) {
         if (e.target == canvas) {
             e.preventDefault();
         }
     }, false);

     (function drawLoop() {
         requestAnimFrame(drawLoop);
         renderCanvas();         
     })();

     function clearCanvas() {
         canvas.width = canvas.clientWidth;
     }

     //window.onresize = function (e) {
     //    canvas.width = canvas.clientWidth;
     //};

     // Set up the UI

     var clearBtn = document.getElementById("sig-clearBtn");

     clearBtn.addEventListener("click", function (e) {
         clearCanvas();
         sigImage.setAttribute("src", "");
     }, false);


 }