﻿using Serilog;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace KarleyUpdate
{
    internal static class AbverkaufsCheck
    {
        public static async Task RunAsync(ILogger logger)
        {
            using FbController2 fbController = new FbController2();
            EmailController emailController = new EmailController();
            DataTable artikel = await fbController.SelectDataAsync(@"SELECT * FROM ARTIKEL AS A 
LEFT JOIN ARTIKELWERTE AS AW ON A.ARTI_A_NR = AW.ARWE_A_NR 
WHERE A.ARTI_L_ABVERKAUF = 'Y' 
AND A.ARTI_L_INAKT_ABVER = 'Y'
AND AW.ARWE_N_BESTAND = 0 
AND A.ARTI_L_INAKTIV = 'N'");
            
            string artikelText = "";
            artikelText = "Folgende Artikel sind auf Abverkauf + Inaktiv nach Abverkauf gestellt. Ggf. prüfen und löschen.<br /><br />";

            foreach (DataRow row in artikel.Rows)
            {
                artikelText += $"{row["ARTI_A_NR"]}<br />";
            }

            await emailController.SendenAsync(GlobalConfig.EmailShopverwalter, "Artikel auf Abverkauf + Inaktiv nach Abverk.", artikelText);
        }
    }
}
