﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace KarleyLibrary.Erweiterungen
{
    public static class HashSetErweiterung
    {
        /// <summary>
        /// Findet alle fehlenden Nummern in einem IEnumerable.
        /// </summary>
        /// <param name="values"></param>
        /// <returns></returns>
        public static IEnumerable<int> FindeFehlendeNummern(IEnumerable<int> values)
        {
            if (values.Any())
            {
                return FindeFehlendeNummern(values, values.Max());
            }
            else
            {
                return new HashSet<int>();
            }
        }
        /// <summary>
        /// Findet alle fehlenden Nummern in einem IEnumerable.
        /// </summary>
        /// <param name="values"></param>
        /// <returns></returns>
        public static IEnumerable<int> FindeFehlendeNummern(IEnumerable<int> values, int maxValue)
        {
#if DEBUG
            if (values.Count() > 3)
            {
                Console.WriteLine("min:{0}", values.Min());
                Console.WriteLine("max:{0}", maxValue);
                Console.WriteLine("Anzahl:{0}", values.Count());
            }
#endif
            if (values.Any())
            {
                HashSet<int> fehlende = new HashSet<int>(Enumerable.Range(values.Min(), maxValue));
                fehlende.ExceptWith(values);
                return fehlende;
            }
            else
            {
                return new HashSet<int>();
            }
        }
    }
}
