﻿namespace KarleyLibrary.Erweiterungen
{
    /// <summary>
    /// Fügt sinnvolle Array Operationen hinzu
    /// </summary>
    public class ArrayErweiterung
    {
        /// <summary>
        /// Prüft ob ein <see cref="byte[]"/> einen <see cref="int"/> Wert enthält
        /// </summary>
        /// <param name="array">Das zu prüfende Byte Array</param>
        /// <param name="value">Der Wert der in dem Array enthalten sein soll</param>
        /// <returns>Gibt einen <see cref="bool"/> zurück der angibt ob der Wert in dem Array enthalten ist</returns>
        public static bool Contains(byte[] array, int value)
        {
            foreach (byte b in array)
            {
                if (b == value)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        /// Prüft ob alle Werte in dem Byte Array kleiner als der Vergleichs Integer sind
        /// </summary>
        /// <param name="array">Das zu prüfende Array</param>
        /// <param name="value">Der Vergleichswert</param>
        /// <returns>Gibt einen <see cref="bool"/> zurück der angibt ob alle Werte kleiner als der Vergleichswert sind</returns>
        public static bool AllSmallerThan(byte[] array, int value)
        {
            foreach (byte b in array)
            {
                if (b > value)
                {
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// Prüft ob alle Werte in dem Array Größer sind als der Vergleichswert
        /// </summary>
        /// <param name="array">Das zu prüfende Byte Array</param>
        /// <param name="value">Der Vergleichswert</param>
        /// <returns>Gibt einen <see cref="bool"/> zurück der angibt ob alle Werte größer sind als der Vergleichswert</returns>
        public static bool AllGreaterThan(byte[] array, int value)
        {
            foreach (byte b in array)
            {
                if (b < value)
                {
                    return false;
                }
            }
            return true;
        }
    }
}
