﻿using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;

namespace KarleyLibrary.Attributes
{
    [AttributeUsage(AttributeTargets.Property)]
    public sealed class Iso88591Attribute : ValidationAttribute
    {

        public Iso88591Attribute()
        {
            ErrorMessage = "Ungültiges Zeichen gefunden.";
        }


        public override bool IsValid(object? value)
        {
            string? eingabe = value as string;
            return StringErweiterung.IsValidISO(eingabe);
        }
    }
}
