﻿using System;
using System.ComponentModel.DataAnnotations;

namespace KarleyLibrary.Attributes
{
    /// <summary>
    /// Gibt an, dass der Wert einer DateTime Property mindestens der aktuelle Tag sein muss.
    /// </summary>
    [AttributeUsage(AttributeTargets.Property)]
    public sealed class FromNowAttribute : ValidationAttribute
    {
        public FromNowAttribute()
        {
            ErrorMessage = "Date must be past now";
        }

        public override bool IsValid(object? value)
        {
            if (value is null)
            {
                return false;
            }

            bool result = DateTime.TryParse(value.ToString(), out DateTime newValue);

            return result && newValue != default && DateTime.Compare(newValue, DateTime.Now) < 0;
        }
    }
}
