﻿using System;
using System.ComponentModel.DataAnnotations;

namespace KarleyLibrary.Attributes
{
    /// <summary>
    /// Gibt an, dass der Wert einer DateTime Property mindestens der aktuelle Tag sein muss.
    /// </summary>
    [AttributeUsage(AttributeTargets.Property)]
    public sealed class FromBeforeAttribute : ValidationAttribute
    {
        public FromBeforeAttribute()
        {
            ErrorMessage = "Bitte geben Sie ein Datum ein, das sich in der Vergangeheit befindet";
        }


        public override bool IsValid(object? value)
        {
            if (value is null)
            {
                return false;
            }

            var result = DateTime.TryParse(value.ToString(), out DateTime newValue);
            return result && newValue != default && DateTime.Compare(DateTime.Now, newValue) > 0;
        }
    }
}
