﻿using System;

namespace KarleyLibrary.Attributes
{
    /// <summary>
    /// Gibt an, dass die Eigenschaft einen anderen Namen in der Datenbank hat.
    /// <para>
    /// Dieses Attribut wird genutzt von allen DataRowZuObject Erweiterungen.
    /// </para>
    /// </summary>
    [AttributeUsage(AttributeTargets.Property)]
    public sealed class CompareFieldAttribute : Attribute
    {
        /// <summary>
        /// Ruft den zugeordneten Namen zur Datenbank ab.
        /// </summary>
        public string DatenbankFeld { get; }

        /// <summary>
        /// Erstellt ein neues CompareAttribut
        /// </summary>
        /// <param name="feld">Der Name des Feldes, wie es aus der Datenbank ausgelesen wird.</param>
        public CompareFieldAttribute(string feld)
        {
            this.DatenbankFeld = feld;
        }
    }
}
