﻿//#define TEST_LIST

using License;
using License.Library;
using License.Requests;
using License.Responses;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Serilog;
using System;
using System.Diagnostics;
using System.IO;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;
using WK5.Core.Models;
using WK5.Core.Services;
using System.Linq;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Text.Json.Nodes;
using System.Text;
using FluentFTP;
using WK5.Core.Drucken.Angebote;

namespace CoreTester
{
    internal class Program
    {
        static Auftrag? Input;
        static int _zähler = 0;
        private static async Task Main(string[] args)
        {

            var builder = new ConfigurationBuilder();

            BuildConfig(builder);

            // .WriteTo File, sofern benötigt .WriteTo.File(@"logs\test.log", rollingInterval: RollingInterval.Day)
            Log.Logger = new LoggerConfiguration()
                .Enrich.FromLogContext()
                .WriteTo.Console()
                .WriteTo.File(Path.Combine("F:", "CoreTester.log"))
                .CreateLogger();

            var host = Host.CreateDefaultBuilder()
                .ConfigureServices((context, services) =>
                {
                    // Services hinzufügen

                })
                .UseSerilog()
                .Build();

            using FbController2 fbController = new FbController2();

            Angebot meinAngebot = await Angebot.GetAngebotAsync(10100, fbController);
            PrintAngebot printAngebot = await PrintAngebot.CreateAsync(meinAngebot, new PrintAngebotRegelsatz 
            {
                ShowFooter = true,
                ShowHeader = true
            }
            , fbController);

            printAngebot.Print(@"g:\");

            Console.WriteLine("Super coole line");

            Log.Logger.Information("Heftiges krasses LOGGGING");


            //Test

            Console.WriteLine();
        
        }

        public class CustomerPartner
        {
            public int customer_id { get; set; }
            public string Company { get; set; } = string.Empty;
            public string Website { get; set; } = string.Empty;
            public string Paypal { get; set; } = string.Empty;
            public string custom_field { get; set; } = string.Empty;
        }


        private static Regex _regex = new Regex(@"\\u(?<Value>[a-zA-Z0-9]{4})", RegexOptions.Compiled);

        public static string Decoder(string value)
        {
            return _regex.Replace(
                value,
                m => ((char)int.Parse(m.Groups["Value"].Value, NumberStyles.HexNumber)).ToString()
            );
        }


        private static void BuildConfig(IConfigurationBuilder builder)
        {
            builder.SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.json", optional: false, reloadOnChange: true)
                .AddEnvironmentVariables();
        }
    }
}
