﻿window.bootstrap_popover_timers = window.bootstrap_popover_timers || {};

export function setup(id, options) {
    try {
        destroy(id);
        var identifier = "bootstrap-popover-" + id;
        var element = document.getElementById(identifier);
        
        var oOptions = JSON.parse(options);

        if (element != null && typeof element !== "undefined") {
            var popover = bootstrap.Popover.getOrCreateInstance(element, oOptions);
            setupTimer(id);        
        }
    } catch (e) {
        console.error("Error from Popover Setup " + e.message);
        console.error("Parameters = ID: " + id + " | Options: " + options);
        console.error(e);
    }
}

export function destroy(id) {
    try {
        clearTimer(id);
        var identifier = "bootstrap-popover-" + id;
        var element = document.getElementById(identifier);
        if (element != null && typeof element !== "undefined") {
            var popover = bootstrap.Popover.getInstance(element);

            if (popover != null && typeof popover !== 'undefined') {
                popover.dispose();
            }
        }
    } catch (e) {
        console.error("Error from Popover Destroy " + e.message);
        console.error("Parameters = ID: " + id);
        console.error(e);
    }
}

export function update(id, options) {
    try {
        setup(id, options);
    } catch (e) {
        console.error("Error from Popover Update " + e.message);
        console.error("Parameters = ID: " + id + " | Options: " + options);
        console.error(e);
    }
}


function clearTimer(id) {
    if (window.bootstrap_popover_timers) {
        if (window.bootstrap_popover_timers[id]) {
            clearInterval(window.bootstrap_popover_timers[id]);
            delete window.bootstrap_popover_timers[id];
        }
    }
}

function setupTimer(id) {
    clearTimer(id);
    if (window.bootstrap_popover_timers) {
        window.bootstrap_popover_timers[id] = setInterval((id) => {

            var identifier = "bootstrap-popover-" + id;
            if (!$('#' + identifier).is(":visible")) {
                destroy(id);
            }
        }, 100, id);
    }
}