﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Bootstrap
{
    public class PopoverOptions
    {
        public bool Animation { get; set; } = true;
        public string Container { get; set; } = String.Empty;
        public string Content { get; set; } = String.Empty;
        public int Delay { get; set; } = 0;
        public bool Html { get; set; } = true;
        public PopoverPlacement Placement { get; set; } = PopoverPlacement.Right;
        public string Selector { get; set; } = String.Empty;
        public string Template { get; set; } = "<div class='popover' role='tooltip'><div class='popover-arrow'></div><h3 class='popover-header'></h3><div class='popover-body'></div></div>";
        public string Title { get; set; } = String.Empty;
        public PopoverTrigger[] Trigger { get; set; } = new PopoverTrigger[] { PopoverTrigger.Click };
        public PopoverPlacement[] FallbackPlacements { get; set; } = new PopoverPlacement[] { PopoverPlacement.Top, PopoverPlacement.Right, PopoverPlacement.Bottom, PopoverPlacement.Left };
        public string Boundary { get; set; } = "clippingParents";
        public string CustomClass { get; set; } = String.Empty;
        public bool Sanitize { get; set; } = true;
        public int OffsetSkidding { get; set; } = 0;
        public int OffsetDistance { get; set; } = 0;

        public string ArrayToJson<T>(T[] array)
        {
            string result = "[";
            List<string> values = new List<string>();
            foreach (T o in array)
            {
                values.Add($"\"{o.ToString().ToLower()}\"");
            }

            result += String.Join(',', values);

            result += "]";
            return result;
        }

        public string ToJSON()
        {          
            dynamic tmp = new ExpandoObject();

            tmp.animation = Animation;
            tmp.content = Content;
            tmp.delay = Delay;
            tmp.html = Html;
            tmp.placement = Placement.ToString().ToLower();
            tmp.template = Template;
            tmp.title = Title;
            tmp.trigger = String.Join(' ', Trigger.Distinct().Select(x => x.ToString().ToLower()));
            tmp.fallbackPlacements = FallbackPlacements.Select(x => x.ToString().ToLower()).ToArray();
            tmp.boundary = Boundary;
            tmp.customClass = CustomClass;
            tmp.sanitize = Sanitize;
            tmp.closest = false;
            

            if (String.IsNullOrWhiteSpace(Container))
                tmp.container = false;
            else
                tmp.container = Container;

            if (String.IsNullOrWhiteSpace(Selector))
                tmp.selector = false;
            else
                tmp.selector = Selector;

            //return template.Replace("\r\n", String.Empty);
            return System.Text.Json.JsonSerializer.Serialize(tmp);
        }
    }
}
