﻿using BenchmarkDotNet.Attributes;
using BenchmarkDotNet.Engines;
using BenchmarkDotNet.Running;
using Dapper;
using FirebirdSql.Data.FirebirdClient;
using KarleyLibrary.Erweiterungen;
using System.Data;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;
using WK5.Core.Services;

namespace Benchmark
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            _ = BenchmarkRunner.Run<BenchmarkObjectErweiterung>();
        }
    }

    [MemoryDiagnoser]
    [SimpleJob(runStrategy: RunStrategy.ColdStart, targetCount: 30)]
    public class BenchmarkObjectErweiterung
    {



        [Benchmark]
        [Arguments("VP700")]
        [Arguments("CDR80")]
        public async Task GetArtikeldatenFull(string artikelnummer)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ARTIKELNUMMER", artikelnummer);
            DataRow row = await fbController.SelectRowAsync(@"SELECT
    A.*,
    ARWE_N_BESTAND,
    ARWE_N_BEDARF,
    ARWE_N_BEDARF_FERT,
    ARWE_N_BEDARF_RUEST,
    ARWE_N_BEDARF_FERT_RUEST,
    ARWE_N_BESTAND_EUR,
    ARWE_N_LAGERUMSCHL,
    ARWE_N_LAGERDAUER,
    ARWE_N_LAGERBESTA,
    ARWE_N_GESABEDARF,
    ARWE_N_OFFBESTELL,
    ARWE_D_LETZBEWEG,
    ARWE_D_LAGERDATUM,
    ARWE_N_LAGMENGDAU,
    ARWE_D_INVENTDATUM,
    ARWE_N_INVENTDIFF,
    ARWE_N_INVENTBEST,
    ARWE_N_INVENTMONEY,
    ARWE_N_LETZTEREK,
    ARWE_D_LETZTEREKDATUM,
    ARWE_N_TIEFSTEREK,
    ARWE_N_HOECHSTEREK,
    ARWE_N_DURCHSCHEK,
    ARWE_N_VKDURCHSCHN,
    ARWE_N_KOMMLAGER,
    MWST_N_NR,
    MWST_N_PROZENT,
    MWST_A_BEMERKUNG,
    MWST_D_GUELTIGAB,
    MWST_N_PROZENTALT,
    MASS_A_EINHEIT,
    MASS_N_NACHKOMMA,
    MASS_N_MENGENFAKTOR,
    MASS_L_RUNDFERTIGUNG,
    MASS_N_FERTRUND,
    WK5_ARTI_N_HOEHE_VERPACKUNG,
    WK5_ARTI_N_LAENGE_VERPACKUNG,
    WK5_ARTI_N_BREITE_VERPACKUNG,
    WK5_ARTI_L_ANFRAGEARTIKEL,
    WK5_ARTI_L_ETIKETTENBRIEF,
    WK5_ARTI_L_AUFGABE_TECHNIK,
    WK5_ARTI_A_SUCHBEGRIFF,
    WK5_ARTI_N_KOSTENSTELLE,
    WK5_ARTI_L_SUPPORT_AGREEMENT,
    WK5_ARTI_D_SUPPORT_VALID_UNTIL, 
    WK5_ARTI_N_SUPPORT_DOCID,    
    WK5_ARTI_L_KEIN_TEXT_UPDATE,
    WK5_ARTI_L_KEIN_ZPU,      
    WK5_ARTI_N_PRODUKTGEWICHT,
    WK5_ARTI_N_MUELL_PLASTIK,
    WK5_ARTI_N_MUELL_VERBUNDSTOFF,
    WK5_ARTI_N_MUELL_PAPIER,
    WK5_ARTI_N_MUELL_ALUMINIUM,
    WK5_ARTI_L_PACKTEXT,
    WK5_ARTI_A_PACKTEXT,
    WK5_ARTI_L_HAUPTARTIKEL,
    0 AS ARTI_N_ANZ_BILDER,
    cast((SELECT MAX(ARBE_TIMESTAMP) from artikelbewegung WHERE arbe_a_artinr = arti_a_nr) as TIMESTAMP) AS LETZTEBEWEGUNG,
    WK5_ARTI_N_GEBINDE ,
    (SELECT CASE WHEN COUNT(*) > 0 THEN 'Y' ELSE 'N' END FROM ARTIKELSTUECKLISTE WHERE ARST_A_HAUPTARTI = ARTI_A_NR) AS IST_L_STUECKLISTE,
    (SELECT COALESCE(SUM(CHAR_N_EKPREIS * CHAR_N_MENGEOFFEN) / SUM(CHAR_N_MENGEOFFEN),0) FROM CHARGEN WHERE CHAR_A_ARTINR = a.ARTI_A_NR AND CHAR_N_MENGEOFFEN > 0) AS DURCHSCHNITTSEINKAUFSPREIS
    FROM ARTIKEL a
    LEFT OUTER JOIN ARTIKELWERTE w ON w.ARWE_A_NR = a.ARTI_A_NR
    LEFT OUTER JOIN MEHRWERTSTEUER m ON m.MWST_N_NR = a.ARTI_N_MWSTKENNUNG
    LEFT OUTER JOIN MASSEINHEITEN e ON a.ARTI_A_EINHEIT = e.MASS_A_EINHEIT
WHERE ARTI_A_NR = @ARTIKELNUMMER");

            //Artikel artikel = ObjectErweiterung.DataRowZuObjekt(new Artikel(), row);

        }

        [Benchmark]
        [Arguments("VP700")]
        [Arguments("CDR80")]
        public async Task GetArtikeldatenOhneMasseinheitFull(string artikelnummer)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ARTIKELNUMMER", artikelnummer);
            DataRow row = await fbController.SelectRowAsync(@"SELECT
    A.*,
    ARWE_N_BESTAND,
    ARWE_N_BEDARF,
    ARWE_N_BEDARF_FERT,
    ARWE_N_BEDARF_RUEST,
    ARWE_N_BEDARF_FERT_RUEST,
    ARWE_N_BESTAND_EUR,
    ARWE_N_LAGERUMSCHL,
    ARWE_N_LAGERDAUER,
    ARWE_N_LAGERBESTA,
    ARWE_N_GESABEDARF,
    ARWE_N_OFFBESTELL,
    ARWE_D_LETZBEWEG,
    ARWE_D_LAGERDATUM,
    ARWE_N_LAGMENGDAU,
    ARWE_D_INVENTDATUM,
    ARWE_N_INVENTDIFF,
    ARWE_N_INVENTBEST,
    ARWE_N_INVENTMONEY,
    ARWE_N_LETZTEREK,
    ARWE_D_LETZTEREKDATUM,
    ARWE_N_TIEFSTEREK,
    ARWE_N_HOECHSTEREK,
    ARWE_N_DURCHSCHEK,
    ARWE_N_VKDURCHSCHN,
    ARWE_N_KOMMLAGER,
    MWST_N_NR,
    MWST_N_PROZENT,
    MWST_A_BEMERKUNG,
    MWST_D_GUELTIGAB,
    MWST_N_PROZENTALT,
    WK5_ARTI_N_HOEHE_VERPACKUNG,
    WK5_ARTI_N_LAENGE_VERPACKUNG,
    WK5_ARTI_N_BREITE_VERPACKUNG,
    WK5_ARTI_L_ANFRAGEARTIKEL,
    WK5_ARTI_L_ETIKETTENBRIEF,
    WK5_ARTI_L_AUFGABE_TECHNIK,
    WK5_ARTI_A_SUCHBEGRIFF,
    WK5_ARTI_N_KOSTENSTELLE,
    WK5_ARTI_L_SUPPORT_AGREEMENT,
    WK5_ARTI_D_SUPPORT_VALID_UNTIL, 
    WK5_ARTI_N_SUPPORT_DOCID,    
    WK5_ARTI_L_KEIN_TEXT_UPDATE,
    WK5_ARTI_L_KEIN_ZPU,      
    WK5_ARTI_N_PRODUKTGEWICHT,
    WK5_ARTI_N_MUELL_PLASTIK,
    WK5_ARTI_N_MUELL_VERBUNDSTOFF,
    WK5_ARTI_N_MUELL_PAPIER,
    WK5_ARTI_N_MUELL_ALUMINIUM,
    WK5_ARTI_L_PACKTEXT,
    WK5_ARTI_A_PACKTEXT,
    WK5_ARTI_L_HAUPTARTIKEL,
    0 AS ARTI_N_ANZ_BILDER,
    cast((SELECT MAX(ARBE_TIMESTAMP) from artikelbewegung WHERE arbe_a_artinr = arti_a_nr) as TIMESTAMP) AS LETZTEBEWEGUNG,
    WK5_ARTI_N_GEBINDE ,
    (SELECT CASE WHEN COUNT(*) > 0 THEN 'Y' ELSE 'N' END FROM ARTIKELSTUECKLISTE WHERE ARST_A_HAUPTARTI = ARTI_A_NR) AS IST_L_STUECKLISTE,
    (SELECT COALESCE(SUM(CHAR_N_EKPREIS * CHAR_N_MENGEOFFEN) / SUM(CHAR_N_MENGEOFFEN),0) FROM CHARGEN WHERE CHAR_A_ARTINR = a.ARTI_A_NR AND CHAR_N_MENGEOFFEN > 0) AS DURCHSCHNITTSEINKAUFSPREIS
    FROM ARTIKEL a
    LEFT OUTER JOIN ARTIKELWERTE w ON w.ARWE_A_NR = a.ARTI_A_NR
    LEFT OUTER JOIN MEHRWERTSTEUER m ON m.MWST_N_NR = a.ARTI_N_MWSTKENNUNG
WHERE ARTI_A_NR = @ARTIKELNUMMER");

            //Artikel artikel = ObjectErweiterung.DataRowZuObjekt(new Artikel(), row);

        }


        [Benchmark]
        [Arguments("VP700")]
        [Arguments("CDR80")]
        public async Task GetArtikeldatenOhneMasseinheitFullOptimized(string artikelnummer)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ARTIKELNUMMER", artikelnummer); 
            DataRow row = await fbController.SelectRowAsync(@"SELECT
    A.*,
    ARWE_N_BESTAND,
    ARWE_N_BEDARF,
    ARWE_N_BEDARF_FERT,
    ARWE_N_BEDARF_RUEST,
    ARWE_N_BEDARF_FERT_RUEST,
    ARWE_N_BESTAND_EUR,
    ARWE_N_LAGERUMSCHL,
    ARWE_N_LAGERDAUER,
    ARWE_N_LAGERBESTA,
    ARWE_N_GESABEDARF,
    ARWE_N_OFFBESTELL,
    ARWE_D_LETZBEWEG,
    ARWE_D_LAGERDATUM,
    ARWE_N_LAGMENGDAU,
    ARWE_D_INVENTDATUM,
    ARWE_N_INVENTDIFF,
    ARWE_N_INVENTBEST,
    ARWE_N_INVENTMONEY,
    ARWE_N_LETZTEREK,
    ARWE_D_LETZTEREKDATUM,
    ARWE_N_TIEFSTEREK,
    ARWE_N_HOECHSTEREK,
    ARWE_N_DURCHSCHEK,
    ARWE_N_VKDURCHSCHN,
    ARWE_N_KOMMLAGER,
    MWST_N_NR,
    MWST_N_PROZENT,
    MWST_A_BEMERKUNG,
    MWST_D_GUELTIGAB,
    MWST_N_PROZENTALT,
    WK5_ARTI_N_HOEHE_VERPACKUNG,
    WK5_ARTI_N_LAENGE_VERPACKUNG,
    WK5_ARTI_N_BREITE_VERPACKUNG,
    WK5_ARTI_L_ANFRAGEARTIKEL,
    WK5_ARTI_L_ETIKETTENBRIEF,
    WK5_ARTI_L_AUFGABE_TECHNIK,
    WK5_ARTI_A_SUCHBEGRIFF,
    WK5_ARTI_N_KOSTENSTELLE,
    WK5_ARTI_L_SUPPORT_AGREEMENT,
    WK5_ARTI_D_SUPPORT_VALID_UNTIL, 
    WK5_ARTI_N_SUPPORT_DOCID,    
    WK5_ARTI_L_KEIN_TEXT_UPDATE,
    WK5_ARTI_L_KEIN_ZPU,      
    WK5_ARTI_N_PRODUKTGEWICHT,
    WK5_ARTI_N_MUELL_PLASTIK,
    WK5_ARTI_N_MUELL_VERBUNDSTOFF,
    WK5_ARTI_N_MUELL_PAPIER,
    WK5_ARTI_N_MUELL_ALUMINIUM,
    WK5_ARTI_L_PACKTEXT,
    WK5_ARTI_A_PACKTEXT,
    WK5_ARTI_L_HAUPTARTIKEL,
    0 AS ARTI_N_ANZ_BILDER,
    cast((SELECT MAX(ARBE_TIMESTAMP) from artikelbewegung WHERE arbe_a_artinr = arti_a_nr) as TIMESTAMP) AS LETZTEBEWEGUNG,
    WK5_ARTI_N_GEBINDE ,
    CASE WHEN EXISTS(SELECT 1 FROM ARTIKELSTUECKLISTE WHERE ARST_A_HAUPTARTI = ARTI_A_NR) THEN 'Y' ELSE 'N' END AS IST_L_STUECKLISTE,
    (SELECT COALESCE(SUM(CHAR_N_EKPREIS * CHAR_N_MENGEOFFEN) / SUM(CHAR_N_MENGEOFFEN),0) FROM CHARGEN WHERE CHAR_A_ARTINR = a.ARTI_A_NR AND CHAR_N_MENGEOFFEN > 0) AS DURCHSCHNITTSEINKAUFSPREIS
    FROM ARTIKEL a
    LEFT OUTER JOIN ARTIKELWERTE w ON w.ARWE_A_NR = a.ARTI_A_NR
    LEFT OUTER JOIN MEHRWERTSTEUER m ON m.MWST_N_NR = a.ARTI_N_MWSTKENNUNG
WHERE ARTI_A_NR = @ARTIKELNUMMER");

           //Artikel artikel = ObjectErweiterung.DataRowZuObjekt(new Artikel(), row);

          
        }


        [Benchmark]
        [Arguments("VP700")]
        [Arguments("CDR80")]
        public async Task DapperAsync(string artikelnummer)
        {
           

            FbConnection connection = new FbConnection(GlobalConfig.W4ConnectionString);
            
            FbCommand command = connection.CreateCommand();
            var parameters = new { ARTIKELNUMMER = artikelnummer };
            TestArtikel tmp = await connection.QuerySingleAsync<TestArtikel>(@"SELECT 
    A.*,
    ARWE_N_BESTAND,
    ARWE_N_BEDARF,
    ARWE_N_BEDARF_FERT,
    ARWE_N_BEDARF_RUEST,
    ARWE_N_BEDARF_FERT_RUEST,
    ARWE_N_BESTAND_EUR,
    ARWE_N_LAGERUMSCHL,
    ARWE_N_LAGERDAUER,
    ARWE_N_LAGERBESTA,
    ARWE_N_GESABEDARF,
    ARWE_N_OFFBESTELL,
    ARWE_D_LETZBEWEG,
    ARWE_D_LAGERDATUM,
    ARWE_N_LAGMENGDAU,
    ARWE_D_INVENTDATUM,
    ARWE_N_INVENTDIFF,
    ARWE_N_INVENTBEST,
    ARWE_N_INVENTMONEY,
    ARWE_N_LETZTEREK,
    ARWE_D_LETZTEREKDATUM,
    ARWE_N_TIEFSTEREK,
    ARWE_N_HOECHSTEREK,
    ARWE_N_DURCHSCHEK,
    ARWE_N_VKDURCHSCHN,
    ARWE_N_KOMMLAGER,
    MWST_N_NR,
    MWST_N_PROZENT,
    MWST_A_BEMERKUNG,
    MWST_D_GUELTIGAB,
    MWST_N_PROZENTALT,
    WK5_ARTI_N_HOEHE_VERPACKUNG,
    WK5_ARTI_N_LAENGE_VERPACKUNG,
    WK5_ARTI_N_BREITE_VERPACKUNG,
    WK5_ARTI_L_ANFRAGEARTIKEL,
    WK5_ARTI_L_ETIKETTENBRIEF,
    WK5_ARTI_L_AUFGABE_TECHNIK,
    WK5_ARTI_A_SUCHBEGRIFF,
    WK5_ARTI_N_KOSTENSTELLE,
    WK5_ARTI_L_SUPPORT_AGREEMENT,
    WK5_ARTI_D_SUPPORT_VALID_UNTIL, 
    WK5_ARTI_N_SUPPORT_DOCID,    
    WK5_ARTI_L_KEIN_TEXT_UPDATE,
    WK5_ARTI_L_KEIN_ZPU,      
    WK5_ARTI_N_PRODUKTGEWICHT,
    WK5_ARTI_N_MUELL_PLASTIK,
    WK5_ARTI_N_MUELL_VERBUNDSTOFF,
    WK5_ARTI_N_MUELL_PAPIER,
    WK5_ARTI_N_MUELL_ALUMINIUM,
    WK5_ARTI_L_PACKTEXT,
    WK5_ARTI_A_PACKTEXT,
    WK5_ARTI_L_HAUPTARTIKEL,
    0 AS ARTI_N_ANZ_BILDER,
    cast((SELECT MAX(ARBE_TIMESTAMP) from artikelbewegung WHERE arbe_a_artinr = arti_a_nr) as TIMESTAMP) AS LETZTEBEWEGUNG,
    WK5_ARTI_N_GEBINDE ,
    CASE WHEN EXISTS(SELECT 1 FROM ARTIKELSTUECKLISTE WHERE ARST_A_HAUPTARTI = ARTI_A_NR) THEN 'Y' ELSE 'N' END AS IST_L_STUECKLISTE,
    (SELECT COALESCE(SUM(CHAR_N_EKPREIS * CHAR_N_MENGEOFFEN) / SUM(CHAR_N_MENGEOFFEN),0) FROM CHARGEN WHERE CHAR_A_ARTINR = a.ARTI_A_NR AND CHAR_N_MENGEOFFEN > 0) AS DURCHSCHNITTSEINKAUFSPREIS
    FROM ARTIKEL a
    LEFT OUTER JOIN ARTIKELWERTE w ON w.ARWE_A_NR = a.ARTI_A_NR
    LEFT OUTER JOIN MEHRWERTSTEUER m ON m.MWST_N_NR = a.ARTI_N_MWSTKENNUNG
WHERE ARTI_A_NR = @ARTIKELNUMMER", parameters);
        }


        [Benchmark]
        [Arguments("VP700")]
        [Arguments("CDR80")]
        public async Task FirebirdAsync(string artikelnummer)
        {
            FbCommand command = new FbCommand
            {
                Connection = new FbConnection(GlobalConfig.W4ConnectionString)
            };

            command.Connection.Open();
            command.CommandText = @"SELECT 
    A.*,
    ARWE_N_BESTAND,
    ARWE_N_BEDARF,
    ARWE_N_BEDARF_FERT,
    ARWE_N_BEDARF_RUEST,
    ARWE_N_BEDARF_FERT_RUEST,
    ARWE_N_BESTAND_EUR,
    ARWE_N_LAGERUMSCHL,
    ARWE_N_LAGERDAUER,
    ARWE_N_LAGERBESTA,
    ARWE_N_GESABEDARF,
    ARWE_N_OFFBESTELL,
    ARWE_D_LETZBEWEG,
    ARWE_D_LAGERDATUM,
    ARWE_N_LAGMENGDAU,
    ARWE_D_INVENTDATUM,
    ARWE_N_INVENTDIFF,
    ARWE_N_INVENTBEST,
    ARWE_N_INVENTMONEY,
    ARWE_N_LETZTEREK,
    ARWE_D_LETZTEREKDATUM,
    ARWE_N_TIEFSTEREK,
    ARWE_N_HOECHSTEREK,
    ARWE_N_DURCHSCHEK,
    ARWE_N_VKDURCHSCHN,
    ARWE_N_KOMMLAGER,
    MWST_N_NR,
    MWST_N_PROZENT,
    MWST_A_BEMERKUNG,
    MWST_D_GUELTIGAB,
    MWST_N_PROZENTALT,
    WK5_ARTI_N_HOEHE_VERPACKUNG,
    WK5_ARTI_N_LAENGE_VERPACKUNG,
    WK5_ARTI_N_BREITE_VERPACKUNG,
    WK5_ARTI_L_ANFRAGEARTIKEL,
    WK5_ARTI_L_ETIKETTENBRIEF,
    WK5_ARTI_L_AUFGABE_TECHNIK,
    WK5_ARTI_A_SUCHBEGRIFF,
    WK5_ARTI_N_KOSTENSTELLE,
    WK5_ARTI_L_SUPPORT_AGREEMENT,
    WK5_ARTI_D_SUPPORT_VALID_UNTIL, 
    WK5_ARTI_N_SUPPORT_DOCID,    
    WK5_ARTI_L_KEIN_TEXT_UPDATE,
    WK5_ARTI_L_KEIN_ZPU,      
    WK5_ARTI_N_PRODUKTGEWICHT,
    WK5_ARTI_N_MUELL_PLASTIK,
    WK5_ARTI_N_MUELL_VERBUNDSTOFF,
    WK5_ARTI_N_MUELL_PAPIER,
    WK5_ARTI_N_MUELL_ALUMINIUM,
    WK5_ARTI_L_PACKTEXT,
    WK5_ARTI_A_PACKTEXT,
    WK5_ARTI_L_HAUPTARTIKEL,
    0 AS ARTI_N_ANZ_BILDER,
    cast((SELECT MAX(ARBE_TIMESTAMP) from artikelbewegung WHERE arbe_a_artinr = arti_a_nr) as TIMESTAMP) AS LETZTEBEWEGUNG,
    WK5_ARTI_N_GEBINDE ,
    CASE WHEN EXISTS(SELECT 1 FROM ARTIKELSTUECKLISTE WHERE ARST_A_HAUPTARTI = ARTI_A_NR) THEN 'Y' ELSE 'N' END AS IST_L_STUECKLISTE,
    (SELECT COALESCE(SUM(CHAR_N_EKPREIS * CHAR_N_MENGEOFFEN) / SUM(CHAR_N_MENGEOFFEN),0) FROM CHARGEN WHERE CHAR_A_ARTINR = a.ARTI_A_NR AND CHAR_N_MENGEOFFEN > 0) AS DURCHSCHNITTSEINKAUFSPREIS
    FROM ARTIKEL a
    LEFT OUTER JOIN ARTIKELWERTE w ON w.ARWE_A_NR = a.ARTI_A_NR
    LEFT OUTER JOIN MEHRWERTSTEUER m ON m.MWST_N_NR = a.ARTI_N_MWSTKENNUNG
WHERE ARTI_A_NR = @ARTIKELNUMMER";
            command.Parameters.AddWithValue("@ARTIKELNUMMER", artikelnummer);

            DataTable data = new DataTable();
            var reader = await command.ExecuteReaderAsync();
            await Task.Run(() => { data.Load(reader); });

            var artikel = ObjectErweiterung.DataRowZuObjekt(new Artikel(), data.Rows[0]);
        }
    }


    public class TestArtikel
    {
        public string ARTI_A_NR { get; set; }
        public string ARTI_A_BEZ1 { get; set; }
        public string ARTI_A_BEZ2 { get; set; }
        public string ARTI_A_BEZ3 { get; set; }
        public string ARTI_A_BEZ4 { get; set; }
        public string ARTI_A_BEZ5 { get; set; }
        public string ARTI_A_BEZETIKETT { get; set; }
        public string ARTI_A_POSBEZEICH { get; set; }
        public string ARTI_A_WARENGRUPPE { get; set; }
        public string ARTI_A_UNTERWARENG { get; set; }
        public string ARTI_A_PREISGRUPPE { get; set; }
        public string ARTI_A_EINHEIT { get; set; }
        public string ARTI_N_PREISEINHEITFAKTOR { get; set; }
        public string ARTI_N_EK { get; set; }
        public string ARTI_N_BRUTTO { get; set; }
        public string ARTI_N_VK1BRUTTO { get; set; }
        public string ARTI_N_VK1 { get; set; }
        public string ARTI_N_VK2 { get; set; }
        public string ARTI_N_VK3 { get; set; }
        public string ARTI_N_VK4 { get; set; }
        public string ARTI_N_VK5 { get; set; }
        public string ARTI_N_MWSTKENNUNG { get; set; }
        public string ARTI_D_ERFASSDATUM { get; set; }
        public string ARTI_L_FIXPREIS { get; set; }
        public string ARTI_L_FIXVK3 { get; set; }
        public string ARTI_L_FIXVK4 { get; set; }
        public string ARTI_L_FIXVK5 { get; set; }
        public string ARTI_L_INAKTIV { get; set; }
        public string ARTI_L_INAKT_ABVER { get; set; }
        public string ARTI_L_SCHWVERFUEG { get; set; }
        public string ARTI_L_ABVERKAUF { get; set; }
        public string ARTI_L_LAGERFUEHR { get; set; }
        public string ARTI_L_SN { get; set; }
        public string ARTI_L_SN_ABGANG { get; set; }
        public string ARTI_L_SN_EINGANG { get; set; }
        public string ARTI_L_DIENSTLEIST { get; set; }
        public string ARTI_L_INTERNET { get; set; }
        public string ARTI_L_FAXLISTE { get; set; }
        public string ARTI_L_PREISLISTE { get; set; }
        public string ARTI_L_OHNE_DRUCK { get; set; }
        public string ARTI_L_OHNE_PROV { get; set; }
        public string ARTI_L_LANGTEXT_DR { get; set; }
        public string ARTI_N_RUECKL_ADR { get; set; }
        public string ARTI_N_MINDAUFSCHL { get; set; }
        public string ARTI_N_MIND_VK { get; set; }
        public string ARTI_N_MAXRABATT { get; set; }
        public string ARTI_N_GEWICHT { get; set; }
        public string ARTI_N_LAENGE { get; set; }
        public string ARTI_N_BREITE { get; set; }
        public string ARTI_N_HOEHE { get; set; }
        public string ARTI_N_FLAECHE { get; set; }
        public string ARTI_N_COLLI { get; set; }
        public string ARTI_N_MINBESTAND { get; set; }
        public string ARTI_N_MAXBESTAND { get; set; }
        public string ARTI_A_HERSTELLER { get; set; }
        public string ARTI_A_HERST_NR { get; set; }
        public string ARTI_A_EAN { get; set; }
        public string ARTI_A_ERSATZART { get; set; }
        public string ARTI_N_ZOLLTARIF { get; set; }
        public string ARTI_A_SELEKTION1 { get; set; }
        public string ARTI_A_SELEKTION2 { get; set; }
        public string ARTI_A_SELEKTION3 { get; set; }
        public string ARTI_B_NOTIZ { get; set; }
        public string ARTI_B_LANGTEXT { get; set; }
        public string ARTI_A_LAGER { get; set; }
        public string ARTI_A_LAGER2 { get; set; }
        public string ARTI_A_LAGER3 { get; set; }
        public string ARTI_A_PREISEINHEIT { get; set; }
        public string ARTI_A_URSPRUNGSLAND { get; set; }
        public string ARTI_N_STAFFELM1 { get; set; }
        public string ARTI_N_STAFFELM2 { get; set; }
        public string ARTI_N_STAFFELM3 { get; set; }
        public string ARTI_N_STAFFELM4 { get; set; }
        public string ARTI_N_STAFFELM5 { get; set; }
        public string ARTI_N_STAFFELP1 { get; set; }
        public string ARTI_N_STAFFELP2 { get; set; }
        public string ARTI_N_STAFFELP3 { get; set; }
        public string ARTI_N_STAFFELP4 { get; set; }
        public string ARTI_N_STAFFELP5 { get; set; }
        public string ARTI_N_STAFFELR1 { get; set; }
        public string ARTI_N_STAFFELR2 { get; set; }
        public string ARTI_N_STAFFELR3 { get; set; }
        public string ARTI_N_STAFFELR4 { get; set; }
        public string ARTI_N_STAFFELR5 { get; set; }
        public string ARTI_A_STAFFELWAEHR { get; set; }
        public string ARTI_L_FERTIGUNG { get; set; }
        public string ARTI_L_VERBRAUCH { get; set; }
        public string ARTI_L_KAPAZITAET { get; set; }
        public string ARTI_N_WO_KAPAZITAET { get; set; }
        public string ARTI_A_G_RASTER { get; set; }
        public string ARTI_A_FORMULAR_ETIKETT { get; set; }
        public string ARTI_L_NICHT_IN_BELEGEN { get; set; }
        public string ARTI_N_KONFIGURATOR { get; set; }
        public string ARTI_L_RESTEVERWALTUNG { get; set; }
        public string ARTI_L_ABMASSVERWALTUNG { get; set; }
        public string ARTI_N_STAERKE { get; set; }
        public string ARTI_L_BELE_EINGABE_BREITE { get; set; }
        public string ARTI_L_BELE_EINGABE_LAENGE { get; set; }
        public string ARTI_L_BELE_EINGABE_HOEHE { get; set; }
        public string ARTI_L_BELE_EINGABE_STAERKE { get; set; }
        public string ARTI_L_BELE_EINGABE_BODEN { get; set; }
        public string ARTI_L_BELE_EINGABE_BREITE2 { get; set; }
        public string ARTI_L_BELE_EINGABE_HOEHE2 { get; set; }
        public string ARTI_L_BELE_EINGABE_LAENGE2 { get; set; }
        public string ARTI_A_VORGAENGER { get; set; }
        public string ARTI_A_NACHFOLGER { get; set; }
        public string ARTI_N_ERLOESKONTO { get; set; }
        public string ARTI_L_RABATTAUSSCHLUSS { get; set; }
        public string ARTI_L_NORMTEIL { get; set; }
        public string ARTI_L_PRUEFPLAN { get; set; }
        public string ARTI_A_FORMULAR_PRUEF { get; set; }
        public string ARTI_A_PRODLAGER { get; set; }
        public string ARTI_L_STL_VEREDELUNG { get; set; }
        public string ARTI_L_ERSATZEIL { get; set; }
        public string ARTI_L_VERSCHLEISS { get; set; }
        public string ARTI_N_SPERRUSERID { get; set; }
        public string ARTI_TIMESTAMP { get; set; }
        public string ARTI_N_LASTUSER { get; set; }
        public string WK5_ARTI_N_INVENTUR { get; set; }
        public string WK5_ARTI_N_WICHTIGKEIT { get; set; }
        public string WK5_ARTI_L_ANFRAGEARTIKEL { get; set; }
        public string WK5_ARTI_L_ETIKETTENBRIEF { get; set; }
        public string WK5_ARTI_N_HOEHE_VERPACKUNG { get; set; }
        public string WK5_ARTI_N_LAENGE_VERPACKUNG { get; set; }
        public string WK5_ARTI_N_BREITE_VERPACKUNG { get; set; }
        public string WK5_ARTI_L_AUFGABE_TECHNIK { get; set; }
        public string WK5_ARTI_A_SUCHBEGRIFF { get; set; }
        public string WK5_ARTI_N_KOSTENSTELLE { get; set; }
        public string WK5_ARTI_L_SUPPORT_AGREEMENT { get; set; }
        public string WK5_ARTI_D_SUPPORT_VALID_UNTIL { get; set; }
        public string WK5_ARTI_N_SUPPORT_DOCID { get; set; }
        public string WK5_ARTI_L_KEIN_TEXT_UPDATE { get; set; }
        public string WK5_ARTI_L_KEIN_ZPU { get; set; }
        public string WK5_ARTI_N_PRODUKTGEWICHT { get; set; }
        public string WK5_ARTI_L_HAUPTARTIKEL { get; set; }
        public string WK5_ARTI_N_MUELL_PLASTIK { get; set; }
        public string WK5_ARTI_N_MUELL_VERBUNDSTOFF { get; set; }
        public string WK5_ARTI_N_MUELL_PAPIER { get; set; }
        public string WK5_ARTI_N_MUELL_ALUMINIUM { get; set; }
        public string WK5_ARTI_L_PACKTEXT { get; set; }
        public string WK5_ARTI_A_PACKTEXT { get; set; }
        public string WK5_ARTI_N_VIRT_LAGER { get; set; }
        public string WK5_ARTI_N_GEBINDE { get; set; }
        public string WK5_ARTI_A_HINWEIS { get; set; }
        public string WK5_ARTI_N_ANGEBOTVORLAGE { get; set; }
        public string WK5_ARTI_D_LAST_PREIS_CHANGE { get; set; }
        public string ARTI_L_ARTNUM_AENDERUNG { get; set; }
        public string ARTI_N_WARTUNGSINTERVALL { get; set; }
        public string ARTI_B_WARTUNGSTEXT { get; set; }
    }
}
