﻿using Serilog;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;

namespace ArtikelUpdateOpencart
{
    internal static class Zahlungen
    {
        public static async Task RunAsync(ILogger logger)
        {
            using FbController2 fbController = new FbController2();
            using MySqlController2 mySqlController = new MySqlController2();
            List<Zahlung> zahlungen = await fbController.SelectDataAsync<Zahlung>(@"SELECT 
Z.*, 
BELE_A_TYP, 
BELE_A_KUNDENNR, 
BELE_N_ZAHLUNG, 
BELE_A_BESTAET_NR, 
BELE_L_BEZAHLT 
FROM ZAHLUNGEN Z
LEFT JOIN BELEGE ON REZA_N_RECHNR = BELE_N_NR 
WHERE REZA_TIMESTAMP > DATEADD(-10 DAY TO CURRENT_DATE) 
AND BELE_A_TYP = 'RE'");

            foreach (var zahlung in zahlungen)
            {
                if (zahlung.BELE_A_BESTAET_NR.StartsWith("KL-")) //Nur das ist eine Online Bestellung
                {
                    string OnlineBestellNummer = zahlung.BELE_A_BESTAET_NR.Substring(3);

                    // Jemand im Vertrieb ist so schlau und trägt neben der Onlinenummer noch andere Nummern ein, daher nur die ersten 5 Zeichen
                    if(OnlineBestellNummer.Length > 5)
                    {
                        OnlineBestellNummer = OnlineBestellNummer[0..5];
                    }
                    
                    string StatusSQL = $"SELECT order_status_id from `order` WHERE order_id = '{OnlineBestellNummer}' "; //AND customer_id = '" + Kundennummer + "' //AND order_status_id != 5
                                                                                                                         //Auf Wunsch von Socke wurd die ÜBerpürfung der Kundnenummer raus genommen, weil manchmal ist der Kunde nur eine Gastbestellung.
                    int OrderStatusID = Convert.ToInt32(await mySqlController.FetchObjectAsync($"SELECT order_status_id from `order` WHERE order_id = '{OnlineBestellNummer}'"));
                    //Wenn leerer String, dann gab es noch nicht mal online die Bestellung, oder aber ist Status == 5
                    if (OrderStatusID != 5)
                    {
                        string zahlart = zahlung.REZA_A_ZAHLUNGSART.ToUpper() switch
                        {
                            "B" => "Barzahlung",
                            "G" => $"Verrechnet mit Gutschrift: GU-{zahlung.REZA_N_GUTSCHR_NR}",
                            "L" => "Lastschrift",
                            "P" => "Paypal",
                            "S" => "Scheck",
                            "U" => "Uneinbringlich verbucht wg. Zahlungsunfähigkeit",
                            "Ü" => "Überweisung",
                            "V" => "Verrechnung",
                            _ => "Überweisung",
                        };

                        int order_status_id = 4;
                        
                        if (zahlung.BELE_L_BEZAHLT)
                        {
                            order_status_id = 5;
                        }

                        string ZahlungsUpdateString = @$"INSERT INTO `order_history` 
(
order_id, 
order_status_id, 
Comment, 
Date_added
)
VALUES
(
'{OnlineBestellNummer}', 
{order_status_id}, 
@ZAHLUNGSKOMMENTAR, 
CURRENT_TIMESTAMP
)";
                        string zahlungskommentar = $"Wir haben eine Zahlung in Höhe von EUR: {zahlung.REZA_N_UEBERWIESEN} per {zahlart} verbucht.";
                        zahlungskommentar += $"\r\nZahldatum: {zahlung.REZA_D_UEBERWEIDAT.ToShortDateString()}";

                        mySqlController.AddParameter("@ZAHLUNGSKOMMENTAR", zahlungskommentar);
                        await mySqlController.QueryAsync(ZahlungsUpdateString);

                        mySqlController.AddParameter("@order_status_id", order_status_id);
                        mySqlController.AddParameter("@order_id", OnlineBestellNummer);
                        await mySqlController.QueryAsync($"UPDATE `order` set order_status_id = @order_status_id, date_modified = CURRENT_TIMESTAMP WHERE order_id = @order_id");
                    }
                }



            }//forech ende 
        }

        private class Zahlung
        {
            private string _zahlungsart = string.Empty;
            private string _grund = string.Empty;
            private string _belegnummer = string.Empty;
            private string _kontonummer = string.Empty;
            private string _belegtyp = string.Empty;
            private string _kundennummer = string.Empty;
            private string _bestätigungsNummer = string.Empty;

            public int REZA_N_ID { get; set; }
            public int REZA_N_RECHNR { get; set; }
            public string REZA_A_ZAHLUNGSART { get => _zahlungsart; set => _zahlungsart = value ?? string.Empty; }
            public decimal REZA_N_RECHSUMME { get; set; }
            public decimal REZA_N_UEBERWIESEN { get; set; }
            public DateTime REZA_D_UEBERWEIDAT { get; set; }
            public decimal REZA_N_AUSBUCHSUMM { get; set; }
            public string REZA_A_GRUND { get => _grund; set => _grund = value ?? string.Empty; }
            public decimal REZA_N_SKONTOWERT { get; set; }
            public string REZA_A_BELEGNR { get => _belegnummer; set => _belegnummer = value ?? string.Empty; }
            public string REZA_A_KONTONR { get => _kontonummer; set => _kontonummer = value ?? string.Empty; }
            public decimal REZA_N_SONDER_WERT { get; set; }
            public int REZA_N_GUTSCHR_NR { get; set; }
            public DateTime REZA_TIMESTAMP { get; set; }
            public int REZA_N_LASTUSER { get; set; }

            public string BELE_A_TYP { get => _belegtyp; set => _belegtyp = value ?? string.Empty; }
            public string BELE_A_KUNDENNR { get => _kundennummer; set => _kundennummer = value ?? string.Empty; }
            public int BELE_N_ZAHLUNG { get; set; }
            public string BELE_A_BESTAET_NR { get => _bestätigungsNummer; set => _bestätigungsNummer = value ?? string.Empty; }
            public bool BELE_L_BEZAHLT { get; set; }
        }
    }
}
