﻿using ArtikelUpdateOpencart.Import;
using Dapper;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Serilog;
using System;
using System.IO;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

/* Welche Preise wo:
 * VK_Brutto = Endkunde Brutto
 * VK 1 = Firmenkunde Netto
 * VK 2 = Händler
 * VK 3 = Amazon Brutto
 * VK 4 = Listenpreis
 * VK 5 = DirektPreis OnlineShop
 * 
 * Customer_Groups Online wie in W4:
 * 1 = Endkunde Brutto
 * 2 = Firmenkunde
 * 3 = Händler
 * 4 = Behörde
*/

namespace ArtikelUpdateOpencart
{
    internal class Program
    {

        private static readonly FbController2 _fbController = new FbController2();
        private static readonly MySqlController2 _mySqlController = new MySqlController2();
        private static readonly EmailController _emailController = new EmailController();

        private static async Task Main(string[] args)
        {
            var builder = new ConfigurationBuilder();
            BuildConfig(builder);

            // .WriteTo File, sofern benötigt .WriteTo.File(@"logs\test.log", rollingInterval: RollingInterval.Day)
            Log.Logger = new LoggerConfiguration()
                .ReadFrom.Configuration(builder.Build())
                .Enrich.FromLogContext()
                .WriteTo.File(@"\\SRV01\daten\w4\logs\artikelUpdateOpencart.log", rollingInterval: RollingInterval.Day, retainedFileTimeLimit: TimeSpan.FromDays(14))
                .WriteTo.Console()
                .CreateLogger();

            var host = Host.CreateDefaultBuilder()
                .ConfigureAppConfiguration(builder =>
                {
                    builder.SetBasePath(AppDomain.CurrentDomain.BaseDirectory);
                    builder.AddJsonFile("artikelUpdateOpencart.json", optional: false, reloadOnChange: true);
                })
                .ConfigureServices((context, services) =>
                {
                   
                   
                })
                .UseSerilog()
                .Build();
         
            var configuration = ActivatorUtilities.GetServiceOrCreateInstance<IConfiguration>(host.Services);

            ArtikelUpdateOpencartSettings settings = configuration.Get<ArtikelUpdateOpencartSettings>();
            // Ab hier geht die Anwendung erst los

            int zähler = 0;
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync(); //Damit wir das nicht einige tausend male einlesen müssen!
            SqlMapper.AddTypeHandler(new BoolTypeHandler());
            #region IF args
            if (args.Length > 0)
            {
                Log.Information("{arg} - STARTET", args[0]);
                if (args[0] == "kundenabgleich")
                {
                    await Kundenabgleich.KundenRabatteSynchronisierenAsync(_mySqlController, _fbController, _emailController);
                    await Kundenabgleich.RunAsync(_mySqlController, _fbController, _emailController);
                }
                else if(args[0] is "import-aisci")
                {
                    LieferantenImportAisci import = new LieferantenImportAisci("https://www.aisci.de/downloadpricelist/xml/?user=ley@karley.eu&token=4b8ec61f6abdc85e0a4dc79d8dc051dd", Log.Logger); ;
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "import-dacom")
                {
                    LieferantenImportDacom import = new LieferantenImportDacom("ftp://ftp.dacom.it/Dacom.CSV", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "import-sysob")
                {
                    LieferantenImportSysob import = new LieferantenImportSysob("https://reseller.sysob.de/bin/bpa.exe?job=6&kdnr=24318&pw=45657", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if (args[0] is "import-pulsa")
                {
                    LieferantenImportPulsa import = new LieferantenImportPulsa("https://www.pulsa.de/backend/export/index/18965.csv?feedID=29&hash=ac93dece6e8a6023aeb6d1ab81f9b31f", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if (args[0] is "import-allnet")
                {
                    LieferantenImportAllnet import = new LieferantenImportAllnet("ftp://212.18.29.147/aln56183-allnet.csv", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "import-werddk")
                {
                    LieferantenImportWerdDk import = new LieferantenImportWerdDk("ftp://karley.de/WERD.csv", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "import-also")
                {
                    LieferantenImportAlso import = new LieferantenImportAlso("ftp://paco.actebis.com/pricelist-1.txt.zip", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync(); 
                }
                else if(args[0] is "import-jarltech")
                {
                    LieferantenImportJarltech import = new LieferantenImportJarltech("", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "import-systeam")
                {
                    LieferantenImportSysteam import = new LieferantenImportSysteam("", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if (args[0] is "import-bluestar")
                {
                    LieferantenImportBluestar import = new LieferantenImportBluestar("", Log.Logger);
                    await import.DownloadAsync();
                    await import.RunAsync();
                }
                else if(args[0] is "export-karley")
                {
                    await KarleyExport.RunAsync(settings, Log.Logger);
                }
                else if(args[0] is "onlinebestand")
                {
                    OnlineBestand onlineBestand = new OnlineBestand(Log.Logger);
                    await onlineBestand.RunAsync();
                }
                else if(args[0] is "zahlungen")
                {
                    await Zahlungen.RunAsync(Log.Logger);
                }
                else if (args[0] is "artikelimport")
                {
                    ArtikelImport artikelImport = new ArtikelImport(Log.Logger);
                    await artikelImport.RunAsync();
                }
                else if (args[0] is "jarltech-zubehör-import")
                {
                    await JarltechZubehörImport.RunAsync(Log.Logger);
                }
                Log.Information("{arg} - BEENDET", args[0]);
            }
            #endregion
        }

        private static void BuildConfig(IConfigurationBuilder builder)
        {
            builder.SetBasePath(AppDomain.CurrentDomain.BaseDirectory)
                .AddJsonFile("artikelUpdateOpencart.json", optional: false, reloadOnChange: true)
                .AddEnvironmentVariables();
        }
    }
}
