﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace ArtikelUpdateOpencart
{
    internal class NamensKlasse
    {
        public string Name1 { get; set; } = string.Empty;
        public string Name2 { get; set; } = string.Empty;
        public string Name3 { get; set; } = string.Empty;
        public string Name4 { get; set; } = string.Empty;
        public string Name5 { get; set; } = string.Empty;
        
        private int _maxZeichen;
        /// <summary>
        /// Filtert Sonderzeichen aus dem Namen des Artikels und splittet diese bei der angegebenen Länge
        /// </summary>
        /// <param name="artikelname"></param>
        /// <param name="zeichenProZeile">nach wie vielen zeichen soll gesplittet werden</param>
        public NamensKlasse(string artikelname, int zeichenProZeile)
        {
            _maxZeichen = zeichenProZeile;
            string HilfsString = "";
            bool istVerarbeitet = false;

            //Sonderzeichen aus dem ggf. Web entfernen und Leerzeichen etc.
            artikelname = System.Net.WebUtility.HtmlDecode(artikelname);
            artikelname = artikelname.Replace("&nbsp;", "").Replace("&quot;", "").Replace("&amp;", "");

            artikelname = Regex.Replace(artikelname, @"<[^>]*>", " "); // HTML TAGS gegen leerzeichen austauschen
            artikelname = Regex.Replace(artikelname, "[ ]{2,}", " "); // Doppelte Leerzeichen entfernen
            //artikelname = Regex.Replace(Artikelname, "[^a-zA-Z0-9-,-;-//-ü-Ü-ö-Ö-ü-Ü-ß-@\"]", " "); // Alle Sonderzeichen Raus Zahle, Umlaute etc. bleiben!

            artikelname = artikelname.Trim();
            artikelname = StringErweiterung.RemoveMultipleCharOccurence(artikelname, ' ');

            //Anfang komma löschen
            if (artikelname.EndsWith(","))
            {
                artikelname = artikelname.Remove(artikelname.Length - 1, 1);
            }

            if (artikelname.StartsWith(","))
            {
                artikelname = artikelname.Remove(0, 1);
            }

            if (artikelname.Length > zeichenProZeile)
            {
                Name1 = this.SplitWords(artikelname);
                HilfsString = artikelname.Substring(Name1.Length + 1);
            }
            else
            {
                Name1 = artikelname;
                HilfsString = "";
                istVerarbeitet = true;
            }

            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > zeichenProZeile && istVerarbeitet == false)
            {
                Name2 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name2.Length + 1);
            }
            else if (HilfsString.Length > 0 && istVerarbeitet == false)
            {
                Name2 = HilfsString;
                HilfsString = "";
                istVerarbeitet = true;
            }

            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > zeichenProZeile && istVerarbeitet == false)
            {
                Name3 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name3.Length + 1);
            }
            else if (HilfsString.Length > 0 && istVerarbeitet == false)
            {
                Name3 = HilfsString;
                HilfsString = "";
                istVerarbeitet = true;
            }

            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > zeichenProZeile && istVerarbeitet == false)
            {
                Name4 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name4.Length + 1);
            }
            else if (HilfsString.Length > 0 && istVerarbeitet == false)
            {
                Name4 = HilfsString;
                HilfsString = "";
                istVerarbeitet = true;
            }

            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > zeichenProZeile && istVerarbeitet == false)
            {
                Name5 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name5.Length + 1);
            }
            else if (HilfsString.Length > 0 && istVerarbeitet == false)
            {
                Name5 = HilfsString.Trim();
                HilfsString = "";
                istVerarbeitet = true;
            }

        }
        /// <summary>
        /// Die Funktion splittet die Artikelbezeichnung nach spätestens der angebenen MaxZeichen und frühstens vor dem letzten Leerzeichen im angegebenen Intervall
        /// </summary>
        /// <param name="artikelname"></param>
        /// <returns></returns>
        private string SplitWords(string artikelname)
        {
            string tempName = artikelname.Substring(0, this._maxZeichen);
            int posLeerzeichen = tempName.LastIndexOf(" ");
            if (posLeerzeichen >= 0)
                tempName = tempName.Substring(0, posLeerzeichen);

            return tempName;
        }
    }
}
