﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;

namespace ArtikelUpdateOpencart.Models
{
    internal class OnlineKategorien
    {
        public DataTable _alleKategorien;

        private OnlineKategorien(DataTable alleKategorien)
        {
            _alleKategorien = alleKategorien;
        }

        public static async Task<OnlineKategorien> CreateAsync(MySqlController2 mySqlController)
        {
            DataTable data = await mySqlController.SelectDataAsync("SELECT c.category_id, cd.name, c.parent_id from category c left join category_description cd ON c.category_id = cd.category_id where cd.language_id = 2 ORDER BY c.category_id ASC");

            return new OnlineKategorien(data);
        }


        public int GetRootCatID(int category_id, int AbbruchCounter)
        {
            try
            {
                if (AbbruchCounter > 6)
                {
                    return 2536;//AbbruchFunktion Cat-ID falls nach 6 Rekursionen nichts gefunden wurde - >sonstiges zurück
                }

                DataRow[] ErgebnisReihen = _alleKategorien.Select($"category_id = {category_id}");

                int parentId = ErgebnisReihen[0].Field<int>("parent_id"); //Hier könnte ein Fehler fogen!

                if (parentId != 0)
                {
                    AbbruchCounter++;
                    category_id = GetRootCatID(parentId, AbbruchCounter);
                } //Ansonsten haben wir schon die Hauptwarengruppe und können einfach Catstring zurück geben
            }
            catch (Exception)
            {
                return 0;
            }
            return category_id;
        }
    }
}
