﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;

namespace ArtikelUpdateOpencart.Models
{
    /// <summary>
    /// Stellt einen Arikel für den <see cref="ArtikelImport"/> dar
    /// </summary>
    internal class OnlineArtikel
    {
        public int ProductId { get; set; }
        public string Model { get; set; }
        public string Name { get; set; }
        public decimal Price { get; set; }
        public decimal Weight { get; set; }
        public int WeightClassId { get; set; }
        public int Status { get; set; }
        public int ManufacturerId { get; set; }
        public string MPN { get; set; }
        public string EAN { get; set; }
        public int Minimum { get; set; }
        public int CategoryId { get; set; }
        public decimal Length { get; set; }
        public decimal Width { get; set; }
        public decimal Height { get; set; }
        public int LenghtClassId { get; set; }
        public string ManufacturerName { get; set; } = string.Empty;
        public LengthClasses LengthClass { get; set; }

        public Artikel ToImportArtikel(Mehrwertsteuer mehrwertsteuer, OnlineKategorien onlineKategorien)
        {

            ArtikelNamensKlasse artikelNamen = new ArtikelNamensKlasse(Name, 60);
            Artikel artikel = new Artikel
            {
                Artikelnummer = Model,
                ARTI_N_GEWICHT = Weight,
                ARTI_L_INAKTIV = Status != 1,
                ARTI_N_VK1 = Price,
                ARTI_N_VK3 = Price * 1.5m,
                ARTI_N_VK4 = 0,
                ARTI_N_VK5 = Price,
                ARTI_N_LAENGE = Length,
                Breite = Width,
                ARTI_N_HOEHE = Height,
                Herstellernummer = MPN,
                Warengruppe = onlineKategorien.GetRootCatID(CategoryId, 0).ToString(),
                ARTI_N_MWSTKENNUNG = mehrwertsteuer.MWST_N_NR,
                ARTI_N_BRUTTO = Price * (100 + (mehrwertsteuer.MWST_D_GUELTIGAB.Date <= DateTime.Today ? mehrwertsteuer.MWST_N_PROZENT : mehrwertsteuer.MWST_N_PROZENTALT)) / 100,
                ARTI_N_COLLI = Minimum > 0 ? Minimum : 1,
                Bezeichnung1 = artikelNamen.Name1,
                Bezeichnung2 = artikelNamen.Name2,
                Bezeichnung3 = artikelNamen.Name3,
                Bezeichnung4 = artikelNamen.Name4,
                Bezeichnung5 = artikelNamen.Name5,
                Hersteller = ManufacturerName,
                ARTI_A_EINHEIT = "Stck",
                ARTI_L_INTERNET = true,
                Preisgruppe = "STANDARD",
                ARTI_L_LAGERFUEHR = true,
                PreisoptionOnline = 1,
                ARTI_L_FIXVK4 = true
            };

            artikel.ARTI_N_VK1BRUTTO = artikel.ARTI_N_BRUTTO;

            if (artikel.ARTI_N_GEWICHT > 0)
            {
                artikel.ARTI_N_GEWICHT = decimal.Divide(artikel.ARTI_N_GEWICHT, WeightClassId);
            }

            if (StringErweiterung.IsValidEan(EAN))
            {
                artikel.ARTI_A_EAN = EAN;
            }

            if (artikel.Warengruppe is "0")
            {
                artikel.Warengruppe = "PC-TECHNIK";
            }

            LengthClass = LenghtClassId > 2 || LenghtClassId <= 0 ? LengthClasses.Unbekannt : (LengthClasses)LenghtClassId;

            if(LengthClass is LengthClasses.Millimeter)
            {
                artikel.ARTI_N_LAENGE = artikel.ARTI_N_LAENGE / 10;
                artikel.Breite = artikel.Breite / 10;
                artikel.ARTI_N_HOEHE = artikel.ARTI_N_HOEHE / 10;
            }

            // Wenn es schon eine MainKat ist, dann gibt es keine Unterkategorie
            artikel.Unterwarengruppe = CategoryId.ToString() == artikel.Warengruppe ? string.Empty : CategoryId.ToString();

            return artikel;
        }
    }

    public enum LengthClasses
    {
        Unbekannt = 0, // Es kann sein, dass Online keine Längenangaben hinterlegt sind
        Centimeter = 1,
        Millimeter = 2
    }
}
