﻿using KarleyLibrary.Erweiterungen;
using System.Data;
using System.Threading.Tasks;
using WK5.Core;

namespace ArtikelUpdateOpencart.Models
{
    public class ArtikelInfo
    {
        private string _herstellernummer = string.Empty;
        private string _hersteller = string.Empty;
        private string _ean = string.Empty;
        private string _artikelnummer = string.Empty;
        private string _notiz = string.Empty;

        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? string.Empty; }
        public string EAN { get => _ean; set => _ean = value ?? string.Empty; }
        public string Hersteller { get => _hersteller; set => _hersteller = value ?? string.Empty; }
        public string Herstellernummer { get => _herstellernummer; set => _herstellernummer = value ?? string.Empty; }
        public string Notiz { get => _notiz; set => _notiz = value ?? string.Empty; }
        public static async Task<ArtikelInfo?> GetArtikelInfoAsync(int lieferantenId, string bestellnummer, FbController2 fbController)
        {
            string sql = @"SELECT 
coalesce(ARTI_A_EAN, '') AS EAN, 
coalesce(ARTI_A_HERSTELLER, '') AS HERSTELLER, 
coalesce(ARTI_A_HERST_NR, '') AS HERSTELLERNUMMER, 
coalesce(ARTI_A_NR, '') AS ARTIKELNUMMER, 
coalesce(ARTI_B_NOTIZ, '') AS NOTIZ 
FROM ARTIKEL 
WHERE 
ARTI_L_INAKTIV = 'N' 
AND ARTI_A_NR = (
                    SELECT FIRST 1 ARLI_A_ARTIKELNR 
                    FROM LIEFERANTENARTIKEL 
                    WHERE 
                        UPPER(ARLI_A_ARTIKELNR) != @DIVERS 
                        AND UPPER(ARLI_A_ARTIKELNR) != @KARLEY 
                        AND UPPER(ARLI_A_BESTELLNR) = @ARLI_A_BESTELLNR 
                        AND ARLI_N_LIEFNR = @ARLI_N_LIEFNR
                )";



            fbController.AddParameter("@DIVERS", "N");
            fbController.AddParameter("@KARLEY", "N");
            fbController.AddParameter("@ARLI_N_LIEFNR", lieferantenId);
            fbController.AddParameter("@ARLI_A_BESTELLNR", bestellnummer.ToUpper());

            DataRow? row = await fbController.SelectRowAsync(sql);
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new ArtikelInfo(), row);
        }
    }
}
