﻿using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using FileHelpers;
using Serilog;
using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart
{
    internal class JarltechZubehörImport
    {
        public static async Task RunAsync(ILogger logger)
        {
            using FbController2 fbController = new FbController2();
            EmailController emailController = new EmailController();
            int Datensaetzekomplett = 0;
            string datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "jtimport.csv");

            if (File.Exists(datei))
            {

                string[] ignoriereArtikel = { "PMPCR300MF", "PMPCR300-1" };

                List<JarltechArtikel> artikel_daten = new();

                using (TextReader reader = new StreamReader(datei, Encoding.GetEncoding("ISO-8859-1")))
                {
                    CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                    configuration.BadDataFound = null;
                    configuration.Encoding = Encoding.GetEncoding("ISO-8859-1");
                    using (var csv = new CsvReader(reader, configuration))
                    {
                        artikel_daten = csv.GetRecords<JarltechArtikel>().ToList();
                    }
                }

                Datensaetzekomplett = artikel_daten.Count;

               
                DataTable tVersionen = new DataTable();
                tVersionen.Columns.Add("artnr");
                tVersionen.Columns.Add("itemtype");
                tVersionen.Columns.Add("itemgroup");

                DataTable tZubehör = new DataTable();
                tZubehör.Columns.Add("artnr");
                tZubehör.Columns.Add("itemtype");
                tZubehör.Columns.Add("itemgroup");
                logger.Information("Ordne Zubehör...");
                foreach (JarltechArtikel JtArtikel in artikel_daten)
                {

                    if (JtArtikel.ITEM_TYPE.ToLower() == "version")
                    {
                        DataRow dt = tVersionen.NewRow();
                        dt["artnr"] = JtArtikel.ARTNUM;
                        dt["itemgroup"] = JtArtikel.ITEMGROUP_DE;
                        dt["itemtype"] = "version";
                        tVersionen.Rows.Add(dt);
                    }
                    else
                    {
                        DataRow dt = tZubehör.NewRow();
                        dt["artnr"] = JtArtikel.ARTNUM;
                        dt["itemgroup"] = JtArtikel.ITEMGROUP_DE;
                        dt["itemtype"] = "zub";
                        tZubehör.Rows.Add(dt);
                    }
                }
                //Wir haben alles nun in den 2 Tabellen aufteteilt und können nun durchgehen
                logger.Information(messageTemplate: "Prüfe Zubehör...");
                int zähler = 0;
                foreach (DataRow r in tZubehör.Rows)
                {
                    zähler++;
                    Console.Write("\r{0}/{1}\t", zähler, tZubehör.Rows.Count);
                    DataRow[] ergebnis = tVersionen.Select("itemgroup = '" + r["itemgroup"] + "'");
                    //Jetzt jede dieser Rows hinzufügen in die W4, falls diese zuordnung noch nicht existiert!

                    foreach (DataRow iRow in ergebnis)
                    {
                        if (ignoriereArtikel.Contains(iRow["artnr"].ToString().ToUpper()))
                        {
                            continue;
                        }

                        fbController.AddParameter("@Variante", iRow["artnr"].ToString().ToUpper());
                        fbController.AddParameter("@Zubehör", r["artnr"].ToString().ToUpper());
                        object? result = await fbController.FetchObjectAsync("SELECT ARZU_A_AUSGANGSART FROM ARTIKELZUBEHOER WHERE ARZU_A_AUSGANGSART = @Variante AND ARZU_A_ZUBEHOERART = @Zubehör");

                        if (result == null)
                        {
                            
                            try
                            {

                                
                                
                                fbController.AddParameter("@InsertVariante", iRow["artnr"].ToString().ToUpper());
                                fbController.AddParameter("@InsertZubehoer", r["artnr"].ToString().ToUpper());
                                await fbController.QueryAsync(@"INSERT INTO ARTIKELZUBEHOER
(
ARZU_A_AUSGANGSART, 
ARZU_A_ZUBEHOERART,
ARZU_B_NOTIZ,
ARZU_TIMESTAMP,
ARZU_N_LASTUSER
)
VALUES
(
@InsertVariante, 
@InsertZubehoer, 
'JTAutoImport2', 
CURRENT_TIMESTAMP, 
2
)");
                            }
                            catch (Exception ex)
                            {
                                logger.Error("#JarltechZubehörImport_1 - {error}", ex);
                            }
                            finally
                            {
                                fbController.ClearParameters();
                            }
                        }
                    }
                }

                logger.Information("JarltechZubehör Bereinigung wird durchgeführt...");
                #region Bereinigung der Tabellen
                await fbController.QueryAsync("DELETE FROM ARTIKELZUBEHOER WHERE ARZU_A_AUSGANGSART NOT IN (SELECT DISTINCT ARTI_A_NR FROM ARTIKEL)");
                await fbController.QueryAsync("DELETE FROM ARTIKELZUBEHOER WHERE ARZU_A_ZUBEHOERART NOT IN (SELECT DISTINCT ARTI_A_NR FROM ARTIKEL)");
                await fbController.QueryAsync("DELETE FROM ARTIKELZUBEHOER WHERE ARZU_A_AUSGANGSART = ''");
                await fbController.QueryAsync("DELETE FROM ARTIKELZUBEHOER WHERE ARZU_A_ZUBEHOERART = ''");
                #endregion

                
                await emailController.SendenAsync(GlobalConfig.EmailLogsEU, "ArtikelZubehörNeu beendet", "Alle Artikel von Jarltech als Zubehör zugeordnet: ");
            }
            else
            {
                logger.Error("JarltechZubehörImport ist fehlgeschlagen, da die Datei {datei} nicht existiert.", datei);
                await emailController.SendenAsync(GlobalConfig.EmailLogsEU, "ArtikelZubehörNeu beendet", "JT Preisliste wurde nicht heruntergeladen - daher kein Artikel als Zubehör in der neuen Funktion zugeordnet");
            }
        }
    }
}
