﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;
using WK5.Core.Models;

namespace ArtikelUpdateOpencart.Import.Models
{
    public class Wk5ArtikelObject
    {
        public string ARTI_A_NR { get; set; } = string.Empty;
        public string ARTI_A_EAN { get; set; } = string.Empty;
        public string ARTI_A_PREISGRUPPE { get; set; } = "STANDARD";
        
        public decimal NeuerEk { get; set; }
        public decimal ARTI_N_BRUTTO { get; set; }
        public decimal ARTI_N_VK1BRUTTO { get; set; }
        public decimal NeuerVk1 { get; set; }
        public decimal NeuerVk2 { get; set; }
        public decimal NeuerVk3 { get; set; }
        public decimal NeuerVk4 { get; set; }
        public decimal NeuerVk5 { get; set; }
        public bool ARTI_L_FIXPREIS { get; set; }
        public bool ARTI_L_INAKTIV { get; set; }
        public string ARTI_A_HERSTELLER { get; set; } = string.Empty;
        public string ARTI_A_HERST_NR { get; set; } = string.Empty;
        public bool KeinTextUpdate { get; set; }

        [CompareField("ARTI_N_EK")]
        public decimal ALTER_ARTI_N_EK { get; set; }
        [CompareField("ARTI_N_VK1")]
        public decimal ALTER_ARTI_N_VK1 { get; set; }
        [CompareField("ARTI_N_VK2")]
        public decimal ALTER_ARTI_N_VK2 { get; set; }
        [CompareField("ARTI_N_VK3")]
        public decimal ALTER_ARTI_N_VK3 { get; set; }
        [CompareField("ARTI_N_VK4")]
        public decimal ALTER_ARTI_N_VK4 { get; set; }
        [CompareField("ARTI_N_VK5")]
        public decimal ALTER_ARTI_N_VK5 { get; set; }


        public string ARTI_A_SELEKTION1 { get; set; } = string.Empty;
        public string ARTI_A_SELEKTION2 { get; set; } = string.Empty;
        public string ARTI_A_SELEKTION3 { get; set; } = string.Empty;

        //Alte Preise - die schreiben wir hier hin und können immer noch mal überprüfen, bevor wir was zurück geben!
        
        [CompareField("ARWE_N_BESTAND")]
        public decimal Bestand { get; set; }
        public string ArtikelnummerLieferant { get; }

        public Wk5ArtikelObject(string artikelnummerLieferant, decimal neuerEk)
        {
            ArtikelnummerLieferant = artikelnummerLieferant;
            NeuerEk = neuerEk;

            //Wir wollen hier gar nichtmehr Updaten - 31.03.2015 // Winter
            KeinTextUpdate = true;

            if (ARTI_A_PREISGRUPPE.Length is 0)
            {
                ARTI_A_PREISGRUPPE = "STANDARD";
            }
        }


        public async Task CalcVKMitPreisgruppeAsync(Preisgruppe preisgruppe, decimal listenpreis)
        {
            //ListenPreis Berücksichtigen - wenn Kalk-VK größer, dann ListenPreis nehmen

            decimal berechnungsEK = 0; //Einkaufspreis

            if (Bestand > 0)
            {
                berechnungsEK = ALTER_ARTI_N_EK;
            }
            else
            {
                berechnungsEK = NeuerEk;
            }

            if (berechnungsEK == 0)
            {
                berechnungsEK = NeuerEk;
                ARTI_L_FIXPREIS = true;
            }

            if (!ARTI_L_FIXPREIS)
            {
                ARTI_N_BRUTTO = Rundung(berechnungsEK / (1.0m - (preisgruppe.PRGR_N_BRUTTO / 100)), preisgruppe.PRGR_N_RUNDUNG1);
                if (listenpreis > 0 && ARTI_N_BRUTTO > listenpreis && listenpreis > (berechnungsEK * 1.25m))
                {
                    ARTI_N_BRUTTO = listenpreis; //BruttoEndkunde
                }

                NeuerVk1 = Rundung((berechnungsEK / (1.0m - (preisgruppe.PRGR_N_PREIS1 / 100))), preisgruppe.PRGR_N_RUNDUNG2);
                if (listenpreis > 0 && NeuerVk1 > listenpreis && listenpreis > (berechnungsEK * 1.10m))
                {
                    NeuerVk1 = listenpreis;//Firmen
                }

                NeuerVk2 = Rundung(berechnungsEK / (1.0m - (preisgruppe.PRGR_N_PREIS2 / 100)), preisgruppe.PRGR_N_RUNDUNG3);
                if (listenpreis > 0 && NeuerVk2 > listenpreis && listenpreis > (berechnungsEK * 1.10m))
                {
                    NeuerVk2 = listenpreis;//Händler
                }

                NeuerVk3 = Rundung(berechnungsEK / (1.0m - (preisgruppe.PRGR_N_PREIS3 / 100)), preisgruppe.PRGR_N_RUNDUNG4);
                if (listenpreis > 0 && NeuerVk3 > listenpreis && listenpreis > (berechnungsEK * 1.30m))
                {
                    NeuerVk3 = listenpreis;//Amazon netto (Brutto später)
                }

                if (preisgruppe.PRGR_N_PREIS3 == 0)
                {
                    ALTER_ARTI_N_VK3 = 0; //Damit Bauvista Preise ohne Aufschlag nicht in den Shop importiert werden.
                }

                NeuerVk4 = Rundung(berechnungsEK / (1.0m - (preisgruppe.PRGR_N_PREIS4 / 100)), preisgruppe.PRGR_N_RUNDUNG5); //Listenpreis
                if (listenpreis > 0)
                {
                    NeuerVk4 = listenpreis; //Hier immer den Listenpreis setzen, wenn wir den haben.
                }

                NeuerVk5 = Rundung(berechnungsEK / (1.0m - (preisgruppe.PRGR_N_PREIS5 / 100)), preisgruppe.PRGR_N_RUNDUNG6);
                if (listenpreis > 0 && NeuerVk5 > listenpreis && listenpreis > (berechnungsEK * 1.08m))
                {
                    NeuerVk5 = listenpreis; //DirektShopPreis
                }

                ARTI_N_VK1BRUTTO = Math.Round(NeuerVk1 * (decimal)GlobalConfig.MwSt, 2);
            }
            else
            {
                if ((ALTER_ARTI_N_VK1 < ALTER_ARTI_N_EK 
                    || ALTER_ARTI_N_VK2 < ALTER_ARTI_N_EK 
                    || (ALTER_ARTI_N_VK5 > 0 && ALTER_ARTI_N_VK5 < ALTER_ARTI_N_EK)) && Bestand <= 0)
                {
                    string betreff = $"Achtung im Artikel {ARTI_A_NR} ist der Lieferanten Einkaufspreis höher als unser Verkaufspreis. Dieser Artikel ist auf Fixpreis gestellt und der Preis wird daher nicht automatisch hoch gesetzt. Bitte überprüfen!";
                    await EmailController.FehlerMailSendenAsync(betreff, $"Lieferantenpreis zu hoch: http://wk5.local/Artikel/{ARTI_A_NR} - Dieser Artikel ist auf Fixpreis gestellt und der Preis wird daher nicht automatisch hoch gesetzt. Bitte überprüfen!".Replace("\r\n", "<br/>"), GlobalConfig.EmailShopverwalter);
                }

            }
        }

        private decimal Rundung(decimal zahl, decimal rundungsFaktor)
        {

            int Ganzzahl = (int)zahl;
            decimal KommaWert = zahl - (decimal)Ganzzahl;
            int Zehntel = Convert.ToInt16(KommaWert * 10);
            int Hundertstel = Convert.ToInt16(KommaWert * 100 - KommaWert * 10);
            switch (rundungsFaktor)
            { 
                //2er wollen wir nicht und 0.01 als Rundung ist "normal" - also egal
                case 0.05m:
                    if (Hundertstel > 9 && Hundertstel <= 5)
                    {
                        zahl = Ganzzahl + Convert.ToDecimal(Zehntel) / 10 + 0.05m;
                    }
                    else
                    {
                        zahl = Ganzzahl + Convert.ToDecimal(Zehntel) / 10;
                    }

                    break;

                case 0.09m:
                    zahl = Ganzzahl + Convert.ToDecimal(Zehntel) / 10 + 0.09m;
                    break;
            }
            zahl = Math.Round(zahl, 2);
            return zahl;
        }
    }
}
