﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ArtikelUpdateOpencart.Import.Models
{
    public class GlobalLieferantenArtikel
    {
        private string _ean = string.Empty;
        private decimal _lagerbestand = 0;

        public string Bestellnummer { get; set; } = string.Empty;
        public decimal NettoEinkaufspreis { get; set; }
        public string Hersteller { get; set; } = string.Empty;
        public string Herstellernummer { get; set; } = string.Empty;
        public string Kurzbezeichnung { get; set; } = string.Empty;
        public string EAN { get => _ean; set => _ean = value; }
        public decimal Höhe { get; set; }
        public decimal Breite { get; set; }
        public decimal Länge { get; set; }
        public decimal Gewicht { get; set; }
        public decimal Lagerbestand
        {
            get => _lagerbestand;
            set
            {
                if (value < 0)
                {
                    _lagerbestand = 0;
                }
                else
                {
                    _lagerbestand = value;
                }
            }
        }
        public int Mindestbestellmenge { get; set; }
        public int LieferantenId { get; set; }
        public decimal Versandkosten { get; set; } = 20;

    }
}
