﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using Renci.SshNet;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportSysteam : LieferantenImportBase<SysteamArtikel>
    {
        public const int LIEFERANTENNUMMER = 70150;
        public LieferantenImportSysteam(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            //Datei runterladen
            string datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "systeam.txt");
#if !SKIP_DOWNLOAD
            if(File.Exists(datei))
            {
                File.Delete(datei);
            }

            for (int i = 0; i < 20; i++)
            {
                try
                {
                    using (var sftp = new SftpClient("ftp.systeam.de", "119088", "cnJI29"))
                    {
                        if (!sftp.IsConnected)
                        {
                            sftp.Connect();
                        }

                        using FileStream fileToWrite = File.OpenWrite(datei);
                        sftp.DownloadFile("PRICE/PREISLIST.TXT", fileToWrite);
                        if (sftp.IsConnected)
                        {
                            sftp.Disconnect();
                        }
                    }

                    i = 20;
                }
                catch (Exception)
                {
                    if (i == 19)
                    {
                        await EmailController.FehlerMailSendenAsync("Systeam Download Fehler", "Fehler beim runterladen der Datei, Lieferantenupdate wurde abgebrochen.");
                        Environment.Exit(0);
                    }
                    else
                    {
                        await Task.Delay(60000); // 1 Minute warten
                    }
                }

            }
#endif

            using (TextReader reader = new StreamReader(datei, Encoding.GetEncoding("ISO-8859-1")))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                configuration.BadDataFound = null;
                configuration.Delimiter = "\t";
                configuration.Mode = CsvMode.NoEscape;
                configuration.Encoding = Encoding.GetEncoding("ISO-8859-1");
             
                using (var csv = new CsvReader(reader, configuration))
                {
                    ArtikeldatenLieferant = csv.GetRecords<SysteamArtikel>().ToList();
                }
            }
        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);

#if TestBesonderenArtikel
                if (!artikel.ArtikelNr.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif

                // Überprüft ob der Hersteller in der W4 existiert
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.Hersteller)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.ArtikelNr, LIEFERANTENNUMMER))
                {
                    continue;
                }

                //Preise nach Stueckzahl/VPE aus Datei berechnen 70150_VPEStueck.txt
                artikel.Preis = ersetzen.GibStueckzahlVPEPreis(artikel.Preis, LIEFERANTENNUMMER, artikel.ArtikelNr);

                int mindestmenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.ArtikelNr);
                
                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId= LIEFERANTENNUMMER,
                    Bestellnummer = artikel.ArtikelNr,
                    NettoEinkaufspreis = artikel.Preis,
                    Hersteller = artikel.Hersteller,
                    Herstellernummer = artikel.HerstellerNr,
                    Kurzbezeichnung = artikel.Artikelbezeichnung,
                    Lagerbestand = artikel.Menge,
                    EAN = artikel.EAN,
                    Versandkosten = 6m,
                    Mindestbestellmenge = mindestmenge
                };

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }

            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);
        }
    }
}
