﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportSysob : LieferantenImportBase<SysobArtikel>
    {
        public const int LIEFERANTENNUMMER = 71053;
        public LieferantenImportSysob(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            string datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "24318.csv");
#if !SKIP_DOWNLOAD
            using HttpClient client = new HttpClient();
            string daten = await client.GetStringAsync(DownloadUrl);
            using StreamWriter writer = new StreamWriter(datei, false, Encoding.Default);
            writer.Write(daten);
#endif

            using (TextReader reader = new StreamReader(datei, Encoding.GetEncoding("ISO-8859-1")))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                configuration.BadDataFound = null;
                configuration.MissingFieldFound = null;
                configuration.Encoding = Encoding.ASCII;
                
                using (var csv = new CsvReader(reader, configuration))
                {
                    ArtikeldatenLieferant = csv.GetRecords<SysobArtikel>().ToList();
                }
            }
        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);

#if TestBesonderenArtikel
                if (!artikel.NR.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif

                // Überprüft ob der Herstller in der W4 steht
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.HERSTELLER)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.NR, LIEFERANTENNUMMER))
                {
                    continue;
                }

                artikel.EK = ersetzen.GibStueckzahlVPEPreis(artikel.EK, LIEFERANTENNUMMER, artikel.NR);

                int mindestmenge = 1;
                int ersatzMindestMenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.NR);

                if (ersatzMindestMenge > mindestmenge)
                {
                    mindestmenge = ersatzMindestMenge;
                }

                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId = LIEFERANTENNUMMER,
                    Bestellnummer = artikel.NR,
                    NettoEinkaufspreis = artikel.EK,
                    Hersteller = artikel.HERSTELLER,
                    Herstellernummer = artikel.HSTNUMMER,
                    Kurzbezeichnung = artikel.ARTIKEL1,
                    Lagerbestand = artikel.VMENGE,
                    Versandkosten = 10,
                    Mindestbestellmenge = mindestmenge
                };

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }
            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);
        }

    }
}
