﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportPulsa : LieferantenImportBase<PulsaArtikel>
    {
        public const int LIEFERANTENNUMMER = 70511;
        public LieferantenImportPulsa(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            string datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "Pulsa.csv");
#if !SKIP_DOWNLOAD
            using HttpClient client = new HttpClient();
            string daten = string.Empty;
            for (int i = 0; i < 20; i++)
            {
                try
                {

                    daten = await client.GetStringAsync(DownloadUrl);
                    i = 20;
                }
                catch (Exception)
                {
                    if (i == 19)
                    {
                        await EmailController.FehlerMailSendenAsync("Plusa Download Fehler", "Fehler beim runterladen der Datei, Lieferantenupdate wurde abgebrochen.");
                        Environment.Exit(0);
                    }
                    else
                    {
                        await Task.Delay(60000); // 1 Minute warten
                    }
                }
            }

            await File.WriteAllTextAsync(datei, daten);
#endif
            using (TextReader reader = new StreamReader(datei, Encoding.GetEncoding("ISO-8859-1")))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                configuration.BadDataFound = null;
                using (var csv = new CsvReader(reader, configuration))
                {
                    ArtikeldatenLieferant = csv.GetRecords<PulsaArtikel>().ToList();
                }
            }
        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);

#if TestBesonderenArtikel
                if (!artikel.ARTIKELNUMMER.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif

                // Überprüft ob der Hersteller in der W4 existiert
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.HERSTELLER)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.ARTIKELNUMMER, LIEFERANTENNUMMER))
                {
                    continue;
                }
                //Preise nach Stueckzahl/VPE aus Datei berechnen 70511_VPEStueck.txt
                artikel.EK_NET = ersetzen.GibStueckzahlVPEPreis(artikel.EK_NET, LIEFERANTENNUMMER, artikel.ARTIKELNUMMER);

                int ersatzMindestMenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.ARTIKELNUMMER);
                if (ersatzMindestMenge > artikel.MINDESTBESTELLMENGE)
                {
                    artikel.MINDESTBESTELLMENGE = ersatzMindestMenge;
                }

                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId  = LIEFERANTENNUMMER,
                    Bestellnummer = artikel.ARTIKELNUMMER,
                    NettoEinkaufspreis = artikel.EK_NET,
                    Hersteller = artikel.HERSTELLER,
                    Herstellernummer = artikel.HERSTELLERNUMMER,
                    Kurzbezeichnung = artikel.KURZBEZ_DE,
                    Mindestbestellmenge = artikel.MINDESTBESTELLMENGE,
                    Lagerbestand = artikel.VERFUEGBAR_VERKAUFSLAGER,
                    Versandkosten = 8.80m,
                    EAN = artikel.EAN
                };
                

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }
            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);
        }
    }
}
