﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using FileHelpers;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportDacom : LieferantenImportBase<DacomArtikel>
    {
        public const int LIEFERANTENNUMMER = 71142;
        public LieferantenImportDacom(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            string Datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "Dacom.CSV");

#if !SKIP_DOWNLOAD
            for (int i = 0; i < 20; i++)
            {
                StreamReader? reader = null;
                StreamWriter? myFile = null;
                try
                {
                    FtpWebRequest request = (FtpWebRequest)WebRequest.Create("ftp://ftp.dacom.it/Dacom.CSV");
                    request.Method = WebRequestMethods.Ftp.DownloadFile;
                    request.Credentials = new NetworkCredential("u008768", "karley");
                    FtpWebResponse response = (FtpWebResponse)request.GetResponse();
                    Stream responseStream = response.GetResponseStream();
                    reader = new StreamReader(responseStream, Encoding.Default, true);
                    myFile = new StreamWriter(Datei, false, Encoding.Default);
                    myFile.Write(reader.ReadToEnd());
                    reader.Close();
                    response.Close();
                    myFile.Close();

                    i = 20;
                }
                catch (Exception ex)
                {
                    reader?.Close();
                    myFile?.Close();
                    if (i == 19)
                    {
                        await EmailController.FehlerMailSendenAsync("Dacom Download Fehler", $"Fehler beim runterladen der Datei, Lieferantenupdate wurde abgebrochen.{Environment.NewLine}{ex}");
                        Environment.Exit(0);
                    }
                    else
                    {
                        await Task.Delay(60000); // 1 Minute warten
                    }
                }
            }
#endif
            

            using (TextReader reader = new StreamReader(Datei))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                configuration.BadDataFound = null;
                using (var csv = new CsvReader(reader, configuration))
                {       
                    ArtikeldatenLieferant = csv.GetRecords<DacomArtikel>().ToList();
                }
            }
        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
#if TestBesonderenArtikel
                if (!artikel.Sku.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);
                // Überprüft ob der Herstller in der W4 steht
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.Manufacturer)))
                {
                    continue;
                }
                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.PartNumber, LIEFERANTENNUMMER))
                {
                    continue;
                }

                //Preise nach Stueckzahl/VPE aus Datei berechnen 71142_VPEStueck.txt
                //Beschluss 5.2.2019 - wir addieren 5€ auf jeden Artikel, damit Dacom nicht so häufig bestellt wird, denn Lieferscheine etc. müssen wir hinterherlaufen

                decimal KorrekturEK = artikel.YourPrice;
                KorrekturEK += 5; //addieren 5€ .. wenn das nichts bringt, demnächst 10 oder 15€

                artikel.YourPrice = ersetzen.GibStueckzahlVPEPreis(KorrekturEK, LIEFERANTENNUMMER, artikel.PartNumber);

                int mindestmenge = 1;
                int ersatzMindestMenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.PartNumber);
                if (ersatzMindestMenge > mindestmenge)
                {
                    mindestmenge = ersatzMindestMenge;
                }

                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId = LIEFERANTENNUMMER,
                    Bestellnummer = artikel.PartNumber,
                    NettoEinkaufspreis = artikel.YourPrice,
                    Hersteller = artikel.Manufacturer,
                    Herstellernummer = artikel.PartNumber,
                    Kurzbezeichnung = artikel.Description,
                    Lagerbestand = artikel.StockQuantity,
                    Versandkosten = 10,
                    Mindestbestellmenge = mindestmenge
                };

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }

            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);

        }
    }
}
