﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using Renci.SshNet;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportAlso : LieferantenImportBase<AlsoArtikel>
    {
        public const int LIEFERANTENNUMMER = 70944;
        public LieferantenImportAlso(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            string Datei = "Also-0010852255.zip";
            string Zipfile = Path.Combine(GlobalConfig.W4TmpFolderSrv01, Datei);

#if !SKIP_DOWNLOAD
            //Die Datei macht scheinbar Probleme wenn sie überschrieben wird.
            if (File.Exists(Zipfile))
            {
                File.Delete(Zipfile);
            }

            for (int i = 0; i < 20; i++)
            {
                StreamReader? downloadReader = null;
                StreamWriter? myFile = null;
                try
                {
                    using (var sftp = new SftpClient("paco.actebis.com", "mikaxuweme", "mu0ruwaxigi"))
                    {
                        if (!sftp.IsConnected)
                        {
                            sftp.Connect();
                        }

                        using FileStream fileToWrite = File.OpenWrite(Zipfile);
                        sftp.DownloadFile("pricelist-1.txt.zip", fileToWrite);
                        if (sftp.IsConnected)
                        {
                            sftp.Disconnect();
                        }
                    }
                    
                    i = 20;
                }
                catch (Exception ex)
                {
                    if (i == 19)
                    {
                        await EmailController.FehlerMailSendenAsync("Also Download Fehler", "Fehler beim runterladen der Datei, Lieferantenupdate wurde abgebrochen.");
                        Environment.Exit(0);
                    }
                    else
                    {
                        await Task.Delay(60000); // 1 Minute Warten
                    }
                }
                finally
                {
                    downloadReader?.Close();
                    myFile?.Close();
                }

                //Datei geschrieben - jetzt entpacken
                try
                {
                    System.IO.Compression.ZipFile.ExtractToDirectory(Zipfile, GlobalConfig.W4TmpFolderSrv01, true);
                }
                catch (Exception ex)
                {
                    await EmailController.FehlerMailSendenAsync("Ingramm Zip", ex.Message);
                    throw;
                }

                StreamWriter sw = File.CreateText(Path.Combine(GlobalConfig.W4TmpFolderSrv01, "alsopreise.txt"));

                sw.WriteLine("AlsoNr\tHerstellerNr\tHersteller\tEAN\tArtikelBeschreibung\tStueckzahl\tEK\tUVP\tArtikelGruppe1\tArtikelGruppe2\tArtikelGrupper3\tLetzteZeile1\tLetzteZeile2");

                string? line;
                StreamReader file = new StreamReader(Path.Combine(GlobalConfig.W4TmpFolderSrv01, "0010852255.txt"), Encoding.GetEncoding("ISO-8859-1"));
                while ((line = file.ReadLine()) != null)
                {
                    sw.WriteLine(line);
                }
                sw.Close();

                



            }
#endif
            using (TextReader reader = new StreamReader(Path.Combine(GlobalConfig.W4TmpFolderSrv01, "alsopreise.txt")))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.InvariantCulture);
                configuration.BadDataFound = null;
                configuration.TrimOptions = TrimOptions.Trim;
                configuration.Delimiter = "\t";
                configuration.Encoding = Encoding.GetEncoding("ISO-8859-1");
                using (var csv = new CsvReader(reader, configuration))
                {
                    ArtikeldatenLieferant = csv.GetRecords<AlsoArtikel>().ToList();
                }
            }
        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
#if TestBesonderenArtikel
                if (!artikel.AlsoNr.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);

                //Überprüft ob der Hersteller in der W4 existiert
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.Hersteller)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.AlsoNr, LIEFERANTENNUMMER))
                {
                    continue;
                }

                //Preise nach Stueckzahl/VPE aus Datei berechnen 70944_VPEStueck.txt
                artikel.EK = ersetzen.GibStueckzahlVPEPreis(artikel.EK, LIEFERANTENNUMMER, artikel.AlsoNr);

                int mindestmenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.AlsoNr);
                

                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId = LIEFERANTENNUMMER,
                    Bestellnummer = artikel.AlsoNr,
                    NettoEinkaufspreis = artikel.EK,
                    Hersteller = artikel.Hersteller,
                    Herstellernummer = artikel.HerstellerNr,
                    Kurzbezeichnung = artikel.ArtikelBeschreibung,
                    Lagerbestand = artikel.Stueckzahl ?? 0,
                    EAN = artikel.EAN,
                    Versandkosten = 4.95m,
                    Mindestbestellmenge = mindestmenge
                };

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }

            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);
        }
    }
}
