﻿#if DEBUG
//#define TestBesonderenArtikel
//#define SKIP_DOWNLOAD
#endif
using ArtikelUpdateOpencart.Import.Models;
using CsvHelper;
using CsvHelper.Configuration;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Email;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportAllnet : LieferantenImportBase<AllnetArtikel>
    {
        public const int LIEFERANTENNUMMER = 70009;
        public LieferantenImportAllnet(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            string datei = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "allnet.csv");
#if !SKIP_DOWNLOAD
            for (int i = 0; i < 20; i++)
            {
                StreamReader? reader = null;
                StreamWriter? myFile = null;
                try
                {
                    FtpWebRequest request = (FtpWebRequest)WebRequest.Create("ftp://212.18.29.147/aln56183-allnet.csv");
                    request.Method = WebRequestMethods.Ftp.DownloadFile;
                    request.Credentials = new NetworkCredential("aln56183", "xqc29fGvo2wdw6v5");
                    FtpWebResponse response = (FtpWebResponse)request.GetResponse();
                    using Stream responseStream = response.GetResponseStream();
                    reader = new StreamReader(responseStream, Encoding.Default, true);
                    myFile = new StreamWriter(datei, false, Encoding.Default); 
                    await myFile.WriteAsync(await reader.ReadToEndAsync());
                    i = 20;
                }
                catch (Exception)
                {

                    reader?.Close();
                    myFile?.Close();
                    if (i == 19)
                    {
                        await EmailController.FehlerMailSendenAsync("Allnet Download Fehler", "Fehler beim runterladen der Datei, Lieferantenupdate wurde abgebrochen.");
                        Environment.Exit(0);
                    }
                    else
                    {
                        await Task.Delay(60000); // 1 Minute warten
                    }
                }
                finally
                {
                    reader?.Close();
                    myFile?.Close();
                }
            }
#endif
            using (TextReader reader = new StreamReader(datei))
            {
                CsvConfiguration configuration = new CsvConfiguration(CultureInfo.GetCultureInfo("de-DE"));
                configuration.BadDataFound = null;
                configuration.TrimOptions = TrimOptions.Trim;
                configuration.ShouldQuote = (x) => false;

                ArtikeldatenLieferant = new List<AllnetArtikel>();
                using var csv = new CsvReader(reader, configuration);
                while (csv.Read())
                {
                    try
                    {
                        var artikel = csv.GetRecord<AllnetArtikel>();
                        ArtikeldatenLieferant.Add(artikel);
                    }
                    catch (Exception ex)
                    {
                        Log.Logger.Error("Fehler bei Konvertierung in AllnetArtikel: {error}", ex);
                    }

                }
            }

        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();
            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
#if TestBesonderenArtikel
                if (!artikel.AllnetArtiNr.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);

                // Überprüft ob der Hersteller in der W4 existiert
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.Hersteller)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.AllnetArtiNr, LIEFERANTENNUMMER))
                {
                    continue;
                }
                //Preise nach Stueckzahl/VPE aus Datei berechnen 70511_VPEStueck.txt
                artikel.HEK = ersetzen.GibStueckzahlVPEPreis(artikel.HEK, LIEFERANTENNUMMER, artikel.AllnetArtiNr);

                int mindestbestellmenge = ersetzen.GibMindestmenge(LIEFERANTENNUMMER, artikel.AllnetArtiNr);

                _ = int.TryParse(artikel.Lagerbestand, out int lagerbestand);

                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId = LIEFERANTENNUMMER,
                    Bestellnummer = artikel.AllnetArtiNr,
                    NettoEinkaufspreis = artikel.HEK,
                    Hersteller = artikel.Hersteller,
                    Herstellernummer = Regex.Replace(artikel.HerstellerArtiNr, @"[^\u0000-\u007F]+", string.Empty),
                    Kurzbezeichnung = $"{Regex.Replace(artikel.Produktbezeichnung, @"[^\u0000-\u007F]+", string.Empty)} {Regex.Replace(artikel.Produktbeschreibung, @"[^\u0000-\u007F]+", string.Empty)}",
                    Lagerbestand = lagerbestand,
                    EAN = artikel.EAN,
                    Gewicht = artikel.Gewicht,
                    Versandkosten = 20,
                    Mindestbestellmenge = mindestbestellmenge
                };


                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
            }
            await DeleteInaktiveLieferantenartikelAsync(LIEFERANTENNUMMER, fbController);
        }
    }
}
