﻿#if DEBUG
//#define TestBesonderenArtikel
#endif
using ArtikelUpdateOpencart.Import.Models;
using FileHelpers;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;

namespace ArtikelUpdateOpencart.Import
{
    public class LieferantenImportAisci : LieferantenImportBase<AisciArtikel>
    {
        public const int LIEFERANTENNUMMER = 70037;
        private AisciVerfügbarkeit[] _verfügbarkeit = Array.Empty<AisciVerfügbarkeit>();
        public LieferantenImportAisci(string downloadUrl, ILogger logger) : base(LIEFERANTENNUMMER, downloadUrl, logger)
        {

        }
        public override async Task DownloadAsync()
        {
            using HttpClient client = new();
            var data = await client.GetStreamAsync(DownloadUrl);
            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(AisciFeed));
            var feed = (AisciFeed)serializer.Deserialize(data)!;

            ArtikeldatenLieferant = feed!.PRODUCT.ToList(); // Null ist OK, dann stürzt der Job ab und wir werden benachrichtigt

            var tmp = KarleyLibrary.Serialization.XMLWriter.Serialize(ArtikeldatenLieferant);

            await File.WriteAllTextAsync(Path.Combine(GlobalConfig.W4TmpFolderSrv01, "aisci.xml"), tmp.data);

            string lagerdaten = await client.GetStringAsync("http://www.aisci-shop.de/export/aisci-lagerliste.csv");
            FileHelperEngine engine = new FileHelperEngine(typeof(AisciVerfügbarkeit));
            engine.ErrorManager.ErrorMode = ErrorMode.IgnoreAndContinue;
            _verfügbarkeit = (AisciVerfügbarkeit[])engine.ReadString(lagerdaten);

        }

        public override async Task RunAsync()
        {
            using FbController2 fbController = new FbController2();
            List<string> vorhanden_hersteller = await GetVorhandeneHerstellerAsync(fbController).ToListAsync();
            HerstellerErsetzen ersetzen = await HerstellerErsetzen.CreateAsync();

            int zähler = 0;
            foreach (var artikel in ArtikeldatenLieferant)
            {
#if TestBesonderenArtikel
                if (!artikel.ArtNr.Equals("XXX", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
#endif
                ++zähler;
                Console.Write("\r{0}/{1}\t", zähler, ArtikeldatenLieferant.Count);
                // Überprüft ob der Hersteller in der WK5 existiert
                if (!vorhanden_hersteller.Contains(ersetzen.GetHerstellerErsetzt(artikel.Hersteller)))
                {
                    continue;
                }

                // Überprüft ob der Artikel in IgnoreLieferantenArtikel.txt steht
                if (ersetzen.IsArtikelIgnored(artikel.ArtNr, LieferantenId))
                {
                    continue;
                }

                //Preise nach Stueckzahl/VPE aus Datei berechnen
                artikel.Ihr_Einkaufspreis = ersetzen.GibStueckzahlVPEPreis(artikel.Ihr_Einkaufspreis, LieferantenId, artikel.ArtNr);


                GlobalLieferantenArtikel lieferantenArtikel = new GlobalLieferantenArtikel()
                {
                    LieferantenId = LieferantenId,
                    Bestellnummer = artikel.ArtNr,
                    NettoEinkaufspreis = artikel.Ihr_Einkaufspreis,
                    Hersteller = artikel.Hersteller,
                    Herstellernummer = artikel.HerstellerArtikelNr,
                    Kurzbezeichnung = artikel.Beschreibung1,
                    Mindestbestellmenge = 1,
                    Lagerbestand = GetLagerbestand(artikel.ArtNr),
                    Versandkosten = 7.5m, // https://www.aisci.de/Lieferung-und-Zahlung/
                    EAN = string.Empty // Wird nicht übermittelt
                };

                await LieferantenUpdateGlobalAsync(lieferantenArtikel, ersetzen, fbController, _logger);
                await DeleteInaktiveLieferantenartikelAsync(LieferantenId, fbController);
            }
        }

        private decimal GetLagerbestand(string bestellnummer)
        {
            var tmp = _verfügbarkeit.Where(x => x.Bestellnummer == bestellnummer).FirstOrDefault();

            return tmp is null ? 0 : tmp.Lagerbestand;
        }
    }
}
