﻿using System;
using System.Collections.Generic;
using System.IO;

namespace ArtikelUpdateOpencart
{
    public class FilterUpdateFileParser
    {
        public static Dictionary<int, List<string>> ParseFile(string file)
        {
            return Parse(File.ReadAllText(file));
        }
        public static Dictionary<int, List<string>> Parse(string content)
        {
            Dictionary<int, List<string>> results = new Dictionary<int, List<string>>();
            foreach (string tmpLine in content.Split(new string[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries))
            {
                string line = (string)tmpLine.Clone();
                if (line.StartsWith('#'))
                    continue;

                int tagIndex = line.IndexOf('#');
                if (tagIndex >= 0)
                {
                    line = line.Substring(0, tagIndex - 1);
                }

                string[] sides = line.Split(';', StringSplitOptions.RemoveEmptyEntries);
                if (sides.Length != 2)
                    continue;

                string filter = sides[0];
                string artikel = sides[1];



                if (Int32.TryParse(filter, out int filterId))
                {
                    List<string> artikelnummern = new List<string>();
                    foreach (string artikelnummer in artikel.Split(',', StringSplitOptions.RemoveEmptyEntries))
                    {
                        artikelnummern.Add(artikelnummer);
                    }

                    results.Add(filterId, artikelnummern);
                }
            }

            return results;
        }
    }
}
