<?php
	// Daten für das Newsfeed
	define(ATOM,'Y-m-d\TH:i:sP'); // RFC time
	define(AUTHOR_NAME, 'Karley Deutschland GmbH');
	define(AUTHOR_URI, 'https://www.karley.de');
	define(ARTICLE_ID, 'https://www.dvd-roboter.com');
	$kategorien = array();
	$language = "";
	$xml = "../news/news_de.xml";
	$category = "general";
	$page = 1;
	
?>
<!doctype html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>News hinzufügen</title>	

		<!-- Favicon -->
		<link rel="shortcut icon" href="../img/favicon.ico" type="image/x-icon" />
		<link rel="apple-touch-icon" href="../img/apple-touch-icon.png">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">

		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800%7CShadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- ../vendor CSS -->
		<link rel="stylesheet" href="../vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="../vendor/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../vendor/animate/animate.min.css">
		<link rel="stylesheet" href="../vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="../vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="../vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="../vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="../css/theme.css">
		<link rel="stylesheet" href="../css/theme-elements.css">
		<link rel="stylesheet" href="../css/theme-blog.css">
		<link rel="stylesheet" href="../css/theme-shop.css">

		<!-- Current Page CSS -->
		<link rel="stylesheet" href="../vendor/rs-plugin/css/settings.css">
		<link rel="stylesheet" href="../vendor/rs-plugin/css/layers.css">
		<link rel="stylesheet" href="../vendor/rs-plugin/css/navigation.css">

		<!-- Skin CSS -->
		<link rel="stylesheet" href="../css/skins/default.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="../css/custom.css">

		<!-- Head Libs -->
		<script src="../vendor/modernizr/modernizr.min.js"></script>
		
	</head>
	<body>
		<div class="body">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
		<?php
		function insert_text_into_file($file_path, $suchwort, $neuer_text)
		{
			$Inhalt = file_get_contents($file_path);
			$new_contents = preg_replace($suchwort, $neuer_text, $Inhalt, 1);
			return file_put_contents($file_path, $new_contents);
		}// function end
		
		function UpdateTimeInSitemap($page, $sitemap = "../sitemap.xml")
		{		
			//Documentation: http://de2.php.net/manual/de/function.file.php
			$allLines = file($sitemap);
			$lineOfDate = 0;
			foreach($allLines as $line_num => $line)
			{
				$replace = preg_replace("/\s+/", "", $line);
				if($page == $replace)
				{				
					$lineOfDate = $line_num + 1;
					$allLines[$lineOfDate] = "		<lastmod>" . date("Y-m-d") . "</lastmod>\n";
					break;
				}
			}
			file_put_contents($sitemap, $allLines);
			echo "Sitemap.xml wurde erfolgreich aktualisiert. Eintrag: " . $page . " letzte Bearbeitung: " . date("Y-m-d");	
				
		}// funtion end

		if(isset($_POST['news_submit']))
		{
			$title = $_POST['news_title'];
			$category = $_POST['news_category'];
			$content = nl2br($_POST['news_content']);
			preg_replace("&", "&amp;", $content);
			$language = $_POST['news_language'];

			$page = $_POST['news_page'];
			
			if(empty($title) || empty($category) || empty($content) || empty($language) || !is_numeric($page))
			{
				echo "News konnte nicht gespeichert werden. Bitte füllen Sie alle Felder korrekt aus.";
			}
			else //Variabeln sind nicht leer
			{
				
				
					$xml = "";
					switch($language)
					{
						case "de":
							$xml= "../news/news_de.xml";
							break;
						case "en":
							$xml= "../news/news_en.xml";
							break;
						default:
							$xml= "../news/news_de.xml";
							break;
					} // Switch ende
					
					$current_elements = simplexml_load_file($xml);
					
					$anzahl_news = 0;
					foreach($current_elements->entry as $news)
					{
						$anzahl_news++;
					} 
				
					$id = $anzahl_news + 1; //erhöhe ID um eins
					$datum = date(ATOM);
					
					if($language == "de" && $category == "general")
					{
						$category = "Allgemein";
					}
					
				
				echo "news_" . $language . ".xml wurde erfolgreich aktualisiert. <br />";
					
$news = 'entry>
	<author>
		<name>' . AUTHOR_NAME . '</name>
		<uri>'. AUTHOR_URI . '</uri>
	</author>
	<title>' . $title .'</title>
	<category term="' . strtolower($category) . '" label="' . $category . '"/>
	<link rel="alternate" href="blog-post.php?id=' . $id . '"/>
	<id>' . ARTICLE_ID . '</id>
	<updated>' . $datum .'</updated><!-- RFC 3339 timestamp -->
	<content type="xhtml">
		<div xmlns="http://www.w3.org/1999/xhtml">
			' . $content .' 
		</div>
	</content>	
	</entry>
	<entry';	
					
				
		insert_text_into_file($xml, "<entry>", $news);
		$sitemap_loc = "https://www.dvd-roboter.com/"; 
		switch($page)
		{
			case 0:
			$sitemap_loc = "https://www.dvd-roboter.com/"; 
			break;
			case 1:
			$sitemap_loc = "https://www.dvd-roboter.com/roboweb-free.php"; 
			break;
			case 2:
			$sitemap_loc = "https://www.dvd-roboter.com/roboweb-free-hilfe.php"; 
			break;
			case 3;
			$sitemap_loc = "https://www.dvd-roboter.com/robosplit.php"; 
			break;
			case 4:
			$sitemap_loc = "https://www.dvd-roboter.com/robonetburner.php"; 
			break;
			case 5:
			$sitemap_loc = "https://www.dvd-roboter.com/robowatcher.php"; 
			break;
			case 6:
			$sitemap_loc = "https://www.dvd-roboter.com/roboreader.php"; 
			break;
			case 7:
			$sitemap_loc = "https://www.dvd-roboter.com/robohotfolder.php"; 
			break;
			case 8:
			$sitemap_loc = "https://www.dvd-roboter.com/robomerge.php"; 
			break;
			case 9:
			$sitemap_loc = "https://www.dvd-roboter.com/roboshop.php"; 
			break;
			case 10:
			$sitemap_loc = "https://www.dvd-roboter.com/usbsn.php";
			case 11:
			$sitemap_loc = "https://www.dvd-roboter.com/robophoto.php";			
			break;
			default:
			$sitemap_loc = "https://www.dvd-roboter.com/"; 
			break;
		}
		
		UpdateTimeInSitemap("<loc>" . $sitemap_loc ."</loc>");
				
				
			}
		}
		?>
		<br /><br />
		<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
			<label>Titel:</label>
			<input class="form-control" type="text" value="<?php if(!empty($_POST['news_title'])){ echo $_POST['news_title']; } ?>" name="news_title" /><br />
			<label>Kategorie:</label>
			<select class="form-control" name="news_category">
				<option value="General">Allgemein</option>
				<option value="RoboWeb">RoboWeb</option>
				<option value="RoboSplit">RoboSplit</option>
				<option value="RoboNetBurner">RoboNetBurner</option>
				<option value="RoboWatcher">RoboWatcher</option>
			</select><br />
			<label>Sprache:</label>
			<select class="form-control" name="news_language">
				<option value="de">Deutsch</option>
				<option value="en">Englisch</option>
			</select><br />
			<label>Seite:</label>
			<select class="form-control" name="news_page">
				<option value="0">Start</option>
				<option value="1">Roboweb Free</option>
				<option value="2">Roboweb Free Hilfe</option>
				<option value="3">RoboSplit</option>
				<option value="4">RoboNetBurner</option>
				<option value="5">RoboWatcher</option>
				<option value="6">RoboReader</option>
				<option value="7">RoboHotFolder</option>
				<option value="8">RoboMerge</option>
				<option value="9">RoboShop</option>
				<option value="10">USBSN</option>
				<option value="11">RoboPhoto</option>
			</select><br />
			<textarea rows="6" cols="60" class="form-control" placeholder="News" name="news_content"><?php if(!empty($_POST['news_content'])){ echo $_POST['news_content']; } ?></textarea><br />
			<button class="btn btn-primary" type="submit" name="news_submit">News eintragen</button>
		</form>
		
		<!-- ../vendor Referenzlinks documentation -->
		<script src="../vendor/jquery/jquery.min.js"></script>
		<script src="../vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="../vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="../vendor/jquery-cookie/jquery-cookie.min.js"></script>
		<script src="../vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="../vendor/common/common.min.js"></script>
		<script src="../vendor/jquery.validation/jquery.validation.min.js"></script>
		<script src="../vendor/jquery.easy-pie-chart/jquery.easy-pie-chart.min.js"></script>
		<script src="../vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="../vendor/jquery.lazyload/jquery.lazyload.min.js"></script>
		<script src="../vendor/isotope/jquery.isotope.min.js"></script>
		<script src="../vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="../vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="../vendor/vide/vide.min.js"></script>
		
		<!-- Theme Base, Components and Settings -->
		<script src="../js/theme.js"></script>
		
		<!-- Current Page ../vendor and Views -->
		<script src="../vendor/rs-plugin/js/jquery.themepunch.tools.min.js"></script>
		<script src="../vendor/rs-plugin/js/jquery.themepunch.revolution.min.js"></script>
		
		<!-- Theme Custom -->
		<script src="../js/custom.js"></script>
		
		<!-- Theme Initialization Files -->
		<script src="../js/theme.init.js"></script>
				</div>
			</div>
		</div>
	</div>		
	</body>
</html>	
	