﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Zahlensysteme
{
    public partial class Converter : Form
    {
        char[] hexaArray = new char[] {'A', 'B', 'C', 'D', 'E', 'F' };
        public Converter()
        {
            InitializeComponent();         
        }

        private void Berechne()
        {
            
            double temp = 0;
            int hoch = 0;

            if (rbBinaer.Checked)
            {
                double eingabe = Convert.ToDouble(tbEingabe.Text);
                double Dezimalzahl = 0;
                
                // Berechne Dezimal
                while (eingabe > 0)
                {
                    temp = eingabe % 10;
                    eingabe = Math.Round(eingabe / 10, 0);
                    Dezimalzahl +=  temp * Math.Pow(2, hoch);
                    hoch++;
                }
                // Berechne Hexadezimal
                eingabe = Dezimalzahl;
                string hexadezimal = "";

                while (eingabe > 0)
                {
                    temp = eingabe % 16;
                    eingabe = Math.Floor(eingabe / 16);

                    switch (temp)
                    {
                        case 10:
                            hexadezimal += "A";
                            break;
                        case 11:
                            hexadezimal += "B";
                            break;
                        case 12:
                            hexadezimal += "C";
                            break;
                        case 13:
                            hexadezimal += "D";
                            break;
                        case 14:
                            hexadezimal += "E";
                            break;
                        case 15:
                            hexadezimal += "F";
                            break;
                        default:
                            hexadezimal += temp.ToString();
                            break;
                    }
                }

                lblBinär.Text = "Binär: " + tbEingabe.Text;
                lblDezimal.Text = "Dezimal: " + Dezimalzahl.ToString();
                lblHexadezimal.Text = "Hexadezimal: " + Reverse(hexadezimal);
            }
            else if(rbDezimal.Checked)
            {
                double eingabe = Convert.ToDouble(tbEingabe.Text);
                // Berechne Hexadezimal

                string hexadezimal = "";

                while (eingabe > 0)
                {
                    temp = eingabe % 16;
                    eingabe = Math.Floor(eingabe / 16);

                    switch (temp)
                    {
                        case 10:
                            hexadezimal += "A";
                            break;
                        case 11:
                            hexadezimal += "B";
                            break;
                        case 12:
                            hexadezimal += "C";
                            break;
                        case 13:
                            hexadezimal += "D";
                            break;
                        case 14:
                            hexadezimal += "E";
                            break;
                        case 15:
                            hexadezimal += "F";
                            break;
                        default:
                            hexadezimal += temp.ToString();
                            break;
                    }
                }

                // Berechne Binär
                eingabe = Convert.ToDouble(tbEingabe.Text);
                string binär = "";
                while (eingabe > 0)
                {
                    temp = eingabe % 2;
                    eingabe = Math.Floor(eingabe / 2);
                    binär += temp;
                }
                lblBinär.Text = "Binär: " + Reverse(binär);
                lblDezimal.Text = "Dezimal: " + tbEingabe.Text;
                lblHexadezimal.Text = "Hexadezimal: " + Reverse(hexadezimal);
            }
            else // Hexadezimal
            {
                string eingabeHexa = tbEingabe.Text.ToUpper();

                // Berechne Binär
                string binär = "";
                for (int i = 0 ; i < eingabeHexa.Length; i++)
                {
                    switch (eingabeHexa[i])
                    {
                        case '0':
                            binär += "0000";
                            break;
                        case '1':
                            binär += "0001";
                            break;
                        case '2':
                            binär += "0010";
                            break;
                        case '3':
                            binär += "0011";
                            break;
                        case '4':
                            binär += "0100";
                            break;
                        case '5':
                            binär += "0101";
                            break;
                        case '6':
                            binär += "0110";
                            break;
                        case '7':
                            binär += "0111";
                            break;
                        case '8':
                            binär += "1000";
                            break;
                        case '9':
                            binär += "1001";
                            break;
                        case 'A':
                            binär += "1010";
                            break;
                        case 'B':
                            binär += "1011";
                            break;
                        case 'C':
                            binär += "1100";
                            break;
                        case 'D':
                            binär += "1101";
                            break;
                        case 'E':
                            binär += "1110";
                            break;
                        case 'F':
                            binär += "1111";
                            break;
                    }
                }
                // Berechne Dezimal
                double eingabe = Convert.ToDouble(binär);
                double Dezimalzahl = 0;
                while (eingabe > 0)
                {
                    temp = eingabe % 10;
                    eingabe = Math.Round(eingabe / 10, 0);
                    Dezimalzahl += temp * Math.Pow(2, hoch);
                    hoch++;
                }
                lblDezimal.Text = "Dezimal: " + Dezimalzahl;
                lblHexadezimal.Text = "Hexadezimal: " + tbEingabe.Text;
                lblBinär.Text = "Binär: " + binär;
            }
        }
        /// <summary>
        /// Die Methode Invertiert einen String
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public string Reverse(string s)
        {
            char[] charArray = s.ToCharArray();
            Array.Reverse(charArray);
            return new string(charArray);
        }

        private void tbEingabe_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (rbBinaer.Checked)
                if (e.KeyChar == '0' || e.KeyChar == '1' || char.IsControl(e.KeyChar))
                    e.Handled = false;
                else
                    e.Handled = true;
            else if (rbDezimal.Checked)
                if (char.IsDigit(e.KeyChar) || char.IsControl(e.KeyChar))
                    e.Handled = false;
                else
                    e.Handled = true;
            else // Hexadezimal
                 if (char.IsDigit(e.KeyChar) || hexaArray.Contains(char.ToUpper(e.KeyChar)) || char.IsControl(e.KeyChar))
                e.Handled = false;
            else
                e.Handled = true;
        }

        private void tbEingabe_KeyUp(object sender, KeyEventArgs e)
        {
            if(tbEingabe.Text.Length > 0)
                Berechne();
        }

        private void rbBinaer_CheckedChanged(object sender, EventArgs e)
        {
            tbEingabe.Text = string.Empty;
        }
    }
}
