﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net.Sockets;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading;

namespace TimeClient
{
    class Program
    {
        static TcpClient _connection;
        static NetworkStream inStream = null;

        static bool _connected = false;
        static bool heartbeatReceived = true; // Wird beim Empfang einer HeartbeatNachricht auf true gesetzt und beim senden einer auf False

        static System.Timers.Timer heartbeatTimer;
        static string filesDirectory = Path.Combine(Environment.CurrentDirectory, "files"); // Der Ordner, wo übertragene Dateien gespeichert werden

     

        static void Main(string[] args)
        {
            if(!Directory.Exists(filesDirectory))
            {
                Directory.CreateDirectory(filesDirectory);
            }
            while (!_connected)
            {
                Connect();
                Eingabe();
            }
        }
        static void Connect()
        {
            TcpClient connection = new TcpClient();
#if DEBUG
            // Verbindung aufbauen
            do
            {
                Console.WriteLine("Ziel eingeben (IPv4:PORT):");
                string eingabe = Console.ReadLine();

                string[] eingabeSplittet = eingabe.Split(':');

                if(eingabeSplittet.Length == 2)
                {
                    string ip = eingabeSplittet[0];

                    if (int.TryParse(eingabeSplittet[1], out int _port))
                    {
                        try
                        {
                            connection.Connect(ip, _port);
                            _connected = true;
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                        }
                    }
                }
            }
            while (!_connected);
#else
            connection.Connect("192.168.0.26", 4000);
            connected = true;
#endif
            heartbeatReceived = true;
            _connection = connection;


            inStream = connection.GetStream();

            // Heartbeat
            heartbeatTimer = new System.Timers.Timer(5000); // Alle 30 Sekunden, wie auf dem Server // Debug alle 5 sek
            heartbeatTimer.Elapsed += HeartbeatTimer_Elapsed;
            heartbeatTimer.Enabled = true;
            heartbeatReceived = true;

            /* 
             * Wir konvertieren die Bytes des strings zu Base64, da wir dadurch keine Probleme bei der Darstellung von Sonderzeichen erhalten
             * Ferner können wir so auch Dateien einfach übertragen
             * Weitere Informationen:
             * https://de.wikipedia.org/wiki/Base64
             * https://social.msdn.microsoft.com/Forums/sqlserver/en-US/6a546be8-f36f-4cce-a061-4200e4685400/how-to-send-base64-string-to-my-server?forum=netfxbcl
             */
            string login = "";
            do
            {
                Console.Write("Login: ");
                login = Console.ReadLine();
            } while (string.IsNullOrWhiteSpace(login));
            string login64 = Convert.ToBase64String(System.Text.Encoding.UTF8.GetBytes(login));
            Byte[] sendLogin = System.Text.Encoding.UTF8.GetBytes(login64);

            inStream.Write(sendLogin, 0, sendLogin.Length);

            Console.WriteLine("Verbunden!");

            Thread th = new Thread(new ThreadStart(Empfange));
            th.Start();
            
        }

        private static void HeartbeatTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            if(heartbeatReceived)
            {
                heartbeatReceived = false;
            }
            else
            {
                _connection.Close();
                _connected = false;
                heartbeatTimer.Enabled = false;
                Console.WriteLine("Verbindung zum Server verloren!");
                
            }
        }

        static void Eingabe()
        {
            while (_connected)
            {
                Console.WriteLine("Nachricht senden:");

                string message = Console.ReadLine();


                    bool send = true;

                    object nachrichtenObject = null;

                    if (message.StartsWith("/w")) // Handelt es sich um eine private Message?
                    {
                        string[] splittedMessage = message.Split(' ');

                        if (splittedMessage.Length < 3)
                        {
                            Console.WriteLine("Ungültige Syntax /w <VerbindungsID> <Nachricht>");
                            send = false;
                        }
                        else if (int.TryParse(splittedMessage[1], out int VerbindungsID)) // Nur wenn wir eine Zahl haben, haben wir eine gültige Nachricht
                        {
                            nachrichtenObject = new TimeServerLibrary.PrivateNachricht()
                            {
                                Nachricht = message.Substring(4 + splittedMessage[1].Length), // Starte die Nachricht erst nach /w <ID> -> /w + 2 Leerzeichen + Länge ID
                                Empfänger_ID = VerbindungsID
                            };
                        }
                        else // Keine ID
                        {
                            Console.WriteLine("Ungültige Syntax /w <VerbindungsID> <Nachricht>");
                            send = false;
                        }
                    }
                    else // Nachricht an Alle
                    {

                        nachrichtenObject = new TimeServerLibrary.PublicNachricht()
                        {
                            nachricht = message
                        };

                        if (message.Contains("-f"))
                        {
                            string[] messageSplitted = message.Substring(message.IndexOf("-f")).Split(' ');
                            if (messageSplitted.Length >= 2)
                            {
                                string fileName = messageSplitted[1].Replace("\"", "");

                                if (File.Exists(fileName))
                                {

                                    message = message.Replace(messageSplitted[0] + " " + messageSplitted[1], "");

                                    // Nachträglich Parameter aus Nachricht löschen
                                    ((TimeServerLibrary.PublicNachricht)nachrichtenObject).nachricht = message;


                                    try
                                    {
                                        byte[] _fileContent = File.ReadAllBytes(fileName);
                                        ((TimeServerLibrary.PublicNachricht)nachrichtenObject).fileContent = _fileContent;
                                        ((TimeServerLibrary.PublicNachricht)nachrichtenObject).fileType = Path.GetExtension(fileName);
                                        ((TimeServerLibrary.PublicNachricht)nachrichtenObject).filename = fileName;
                                    }
                                    catch (Exception ex)
                                    {
                                        Console.WriteLine(ex.Message);
                                    }
                                }
                                else
                                {
                                    Console.WriteLine("Die Datei {0} konnte nicht gefunden werden", fileName);
                                }
                            }
                            else
                            {
                                Console.WriteLine("Format für Dateiübertragung ungültig. -f <Datei>");
                            }
                        }

                    }

                if (send)
                {
                    SendData(nachrichtenObject);  
                }
            }
        }
        /// <summary>
        /// Sendet ein Nachrichten Object an den Server
        /// </summary>
        /// <param name="nachricht">Ein Object eines NachrichtenTyps</param>
        static void SendData(object nachricht)
        {
            string message = TimeServerLibrary.NachrichtenSerializer.SerializeObject(nachricht);
            Byte[] sendMessage = System.Text.Encoding.UTF8.GetBytes(message);
            try
            {
                inStream.Write(sendMessage, 0, sendMessage.Length);
            }
            catch (IOException ex)
            {
                Console.WriteLine("{0}", ex.Message);
                _connection.Close();
                _connection.Dispose();
                _connected = false;
                Console.WriteLine("Verbindung zum Server verloren!");
            }
    
        }

        static void Empfange()
        {
            bool loop = true;
            while (loop)
            {
                try
                {
                    // Stream zum lesen holen
                    // Hole nächsten Zeitstring vom Server
                    // Reads NetworkStream into a byte buffer.
                    /*byte[] buffer = new byte[connection.ReceiveBufferSize];
                    int byte_count = inStream.Read(buffer, 0, (int)connection.ReceiveBufferSize);            
                    byte[] formated = new Byte[byte_count];
                    Array.Copy(buffer, formated, byte_count); //handle  the null characteres in the byte array
                    //formated = Convert.FromBase64String(Encoding.UTF8.GetString(formated)); // Wir dekodieren den Base64 String wieder zu einem ByteArray
                    */

                    List<byte> bytesReceived = new List<byte>();
                    while (_connection.Available > 0 && _connection.Connected)
                    {
                        byte[] nextByte = new byte[1];
                        _connection.Client.Receive(nextByte, 0, 1, SocketFlags.None);
                        bytesReceived.AddRange(nextByte);
                    }

                    
                    string data = System.Text.Encoding.UTF8.GetString(bytesReceived.ToArray());

                    if (!string.IsNullOrWhiteSpace(data))
                    {
                        //time = time.Substring(0, time.IndexOf("\n\r")); // Wir wollen den Inhalt bis zum Delimiter!!!!

                        object nachricht = TimeServerLibrary.NachrichtenSerializer.DeserializeObject(data);
                        bool ausgabe = true;
                   
                        if (nachricht.GetType() == typeof(TimeServerLibrary.PublicNachricht))
                        {
                            TimeServerLibrary.PublicNachricht publicNachricht = nachricht as TimeServerLibrary.PublicNachricht;
                            data = publicNachricht.nachricht;

                            if(publicNachricht.fileContent != null) // Der Nachricht hängt eine Datei an
                            {
                                try
                                {
                                    File.WriteAllBytes(Path.Combine(filesDirectory, Path.GetFileName(publicNachricht.filename)), publicNachricht.fileContent);
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.Message);
                                }
                            }

                            
                        }
                        else if (nachricht.GetType() == typeof(TimeServerLibrary.PrivateNachricht))
                        {
                            data = ((TimeServerLibrary.PrivateNachricht)nachricht).Nachricht;
                        }
                        else if (nachricht.GetType() == typeof(TimeServerLibrary.KickNachricht))
                        {
                            data = ((TimeServerLibrary.KickNachricht)nachricht).Nachricht;
                            _connected = false;
                            heartbeatTimer.Enabled = false;
                            
                        }
                        else // Uns erreicht ein Heartbeat des Servers
                        {
                            ausgabe = false; // User soll Heartbeat nicht angezeigt bekommen
                            heartbeatReceived = true;
                            ((TimeServerLibrary.HeartBeatNachricht)nachricht).empfangen = DateTime.Now;
                            //Console.WriteLine("Neue Heartbeatanfrage gesendet um {0}, empfangen um {1}", ((TimeServerLibrary.HeartBeatNachricht)nachricht).gesendet, ((TimeServerLibrary.HeartBeatNachricht)nachricht).empfangen);
                            // Zurück an den Absender
                            SendData(nachricht);
                        }
                        

                        // Setze das Schleifen-Flag zurück
                        // wenn der Server aufgehört hat zu senden
                        
                        loop = !data.Equals("") || !(nachricht.GetType() == typeof(TimeServerLibrary.KickNachricht));

                        // Ausgabe in der Konsole
                        if (ausgabe)
                        {
                            Console.WriteLine(data);
                        }
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    // Setze das Schleifen-Flag zurück
                    // wenn ein Fehler in der Kommunikation aufgetreten ist
                    loop = false;
                    _connected = false;
                }
            }
            // Schließe die Verbindung zum Server
            _connection.Close();
            _connection.Dispose();
        }

       
    }
}
