﻿using System;
using System.Text;
using System.Collections;
using System.Threading;
using System.IO;
using System.Net.Sockets;
using System.Net;
using System.Net.NetworkInformation;
using System.Collections.Generic;
using System.Linq;


namespace TimeServer
{
    class Program
    {
        // Der Listener
        private static TcpListener listener = null;
        // Die Liste der laufenden Server-Threads
        private static ArrayList threads = new ArrayList();

        private static int _port = 8080;
        private static string _host = "";

        private static IniClass inifile = new IniClass();

        private static DateTime serverStarted;

        private static string[] commands = new string[] { "send", "kick", "stop", "uptime", "help", "list" }; // TODO: Dictionary mit Eräuterung

        private static int verbindungsID = 1;

        static void Main(string[] args)
        {
            // Config.ini laden
            int.TryParse(inifile.IniReadValue("Connection", "Port"), out _port);
            _host = inifile.IniReadValue("Connection", "Host");

            //IPAddress[] addresses = Dns.GetHostAddresses("localhost"); // Wandelt localhost in IP um

            // Listener initialisieren und starten
            if (IsPortAvailable() && HatNetzwerkKarte())
            {
                try
                {
                    IPAddress iPAddress = IPAddress.Parse(_host);
                    listener = new TcpListener(iPAddress, _port);
                    listener.Start();
                }
                catch (Exception)
                {
                    Console.WriteLine("Der Server konnte unter der Adresse {0} nicht gestartet werden. Prüfen Sie die Einstellungen in der Config.ini Datei.{1}Drücken Sie eine beliebige Taste zum beenden...", _host, Environment.NewLine);
                    Console.ReadKey();
                }

                serverStarted = DateTime.Now;

                Console.WriteLine("{0} - Der Server wurde gestartet und ist unter folgender Adresse erreichbar {1}:{2}", serverStarted, _host, _port);
                
                // Haupt-Server-Thread initialisieren und starten
                Thread th = new Thread(new ThreadStart(Run));
                th.Start();

                // Benutzerbefehle entgegennehmen
                String cmd = "";
                while (!cmd.ToLower().Equals("stop"))
                {
                    cmd = Console.ReadLine();

                    if (!commands.Contains(cmd.ToLower()))
                        Console.WriteLine("Unbekannter Befehl: " + cmd);

                    if (cmd.Equals("list"))
                    {
                        ListConnected();
                    }
                    else if(cmd.Equals("kick"))
                    {
                        ListConnected();
                        Console.WriteLine("Geben Sie die Verbindungs-ID des zu kickenenden Clienten ein{0}Um zum Hauptmenü zurückzukehren geben sie exit ein", Environment.NewLine);
                        string kickCmd = "";
                        do
                        {
                            kickCmd = Console.ReadLine();
                            int.TryParse(kickCmd, out int VerbindungsID);
                            if(VerbindungsID > 0 && !kickCmd.Equals("exit"))
                            {
                                var selectClient =
                                    from ServerThread client in threads
                                    where client.VerbindungsID == VerbindungsID
                                    select client;

                                if(selectClient.Count() == 1)
                                    selectClient.First().Kick();
                                else
                                    Console.WriteLine("Ungültige Verbindungs-ID!");
                            } 
                        } while (!kickCmd.Equals("exit"));
                    }
                    else if(cmd.Equals("send"))
                    {
                        string sendCmd = "";
                        do
                        {
                            Console.WriteLine("Nachricht Eingeben:");
                            sendCmd = Console.ReadLine();
                            if(!sendCmd.Equals("exit"))
                            {
                                TimeServerLibrary.PublicNachricht publicNachricht = new TimeServerLibrary.PublicNachricht()
                                {
                                    nachricht = sendCmd,
                                    VERSENDER_NAME = "[SERVER]",
                                    fontColor = ConsoleColor.DarkGreen
                                };
                                SendMessage(publicNachricht);
                            }
                        } while (!sendCmd.Equals("exit"));
                    }
                    else if(cmd.Equals("uptime"))
                    {
                        TimeSpan uptime = DateTime.Now - serverStarted;
                        Console.WriteLine(uptime);
                    }
                    else if (cmd.Equals("help"))
                    {
                        Console.WriteLine("Verfügbare Befehle:");
                        foreach (string befehl in commands)
                        {
                            Console.WriteLine(befehl);
                        }
                    }
                }
                // Listener stoppen
                listener.Stop();


                // Haupt-Server-Thread stoppen
                th.Abort();
            

                // Alle Server-Threads stoppen
                for (IEnumerator e = threads.GetEnumerator(); e.MoveNext();)
                {
                    // Nächsten Server-Thread holen
                    ServerThread st = (ServerThread)e.Current;

                    Console.WriteLine("Trenne Verbindung: {0} - {1}", st.IP, st.loginName);
                    // und stoppen
                    st.stop = true;
                    st.heartbeatTimer.Enabled = false;
                    while (st.running)
                        Thread.Sleep(1000);
                }
                Console.WriteLine("Der Server wurde erfolgreich heruntergefahren.{0}Beliebige Taste drücken...", Environment.NewLine);
                Console.ReadKey();
                
            }
            else
            {
                Console.WriteLine("Der Port {0} wird bereits verwendet. Der Server konnte nicht gestartet werden {1}Drücken Sie eine beliebige Taste zum beenden...", _port, Environment.NewLine);
                Console.ReadKey();
            }
            
        }

        /// <summary>
        /// Sendet ein Nachrichten Object an alle verbunden Clients
        /// </summary>
        /// <param name="message"></param>
        public static void SendMessage(object nachrichtenObject)
        {
            string message = TimeServerLibrary.NachrichtenSerializer.SerializeObject(nachrichtenObject); // Message Base64 kodieren

            // Nachricht an alle verfügbaren CLients senden
            for (IEnumerator e = threads.GetEnumerator(); e.MoveNext();)
            {
                // Nächsten Server-Thread holen
                ServerThread st = (ServerThread)e.Current;

                st.Broadcast(Encoding.UTF8.GetBytes(message));
            }
        }

        /// <summary>
        /// Sendet ein Nachrichten Object an einen bestimmten Client
        /// </summary>
        /// <param name="message"></param>
        public static bool SendMessage(object nachrichtenObject, int VerbindungsID)
        {
            string message = TimeServerLibrary.NachrichtenSerializer.SerializeObject(nachrichtenObject); // Message Base64 kodieren

            var sucheEmpfänger =
                from ServerThread empfänger in threads
                where empfänger.VerbindungsID == VerbindungsID
                select empfänger;

            if (sucheEmpfänger.Count() == 1)
            {
                sucheEmpfänger.First().Broadcast(Encoding.UTF8.GetBytes(message));
                return true;
            }
            else
                return false;
        }

        /// <summary>
        /// Listet alle aktuell verbundenen Clients auf.
        /// </summary>
        private static void ListConnected()
        {
            Console.WriteLine("Verbundene Clients");
            for (IEnumerator e = threads.GetEnumerator(); e.MoveNext();)
            {
                // Nächsten Server-Thread holen
                ServerThread st = (ServerThread)e.Current;

                // ausgeben
                Console.WriteLine("{0} - Login-Name: {1} - Verbindungs-ID: {2} - Letzte Differenz: {3}", st.IP, st.loginName, st.VerbindungsID, st.heartbeatDifferenz);
            }
            Console.WriteLine("Aktuelle Verbindungen: {0}", threads.Count);
        }

        /// <summary>
        /// Der Server-Thread, der neue TcpClients empfängt
        /// </summary>
        public static void Run()
        {
            while (true)
            {
                // Wartet auf eingehenden Verbindungswunsch
                TcpClient c = listener.AcceptTcpClient();

                // Erste Übertragung ist immer die Login-Info!!
                // TODO: Login Information als Object übergeben
                NetworkStream ns = c.GetStream();
                
                try
                {
                    //byte[] buffer = new byte[c.ReceiveBufferSize];
                    //int byte_count = ns.Read(buffer, 0, buffer.Length);
                    //byte[] formated = new Byte[byte_count];
                    //Array.Copy(buffer, formated, byte_count); //handle  the null characteres in the byte array
                    //formated = Convert.FromBase64String(Encoding.UTF8.GetString(formated)); // Wir dekodieren den Base64 String wieder zu einem ByteArray

                    //string login = Encoding.UTF8.GetString(formated);

                    // Initialisiert und startet einen Server-Thread
                    // und fügt ihn zur Liste der Server-Threads hinzu



                    ServerThread clientThread = new ServerThread(c)
                    {
                        VerbindungsID = verbindungsID
                    };

                    verbindungsID++;

                    //Console.WriteLine("Neuer Client: {0}{1}PC-Name: {2}{3}Verbindungs-ID: {4}", ((IPEndPoint)c.Client.RemoteEndPoint).Address.ToString(), Environment.NewLine, clientThread.loginName, Environment.NewLine, clientThread.VerbindungsID);
                    clientThread.ClientDisconnected += ClientThread_ClientDisconnected;
                    threads.Add(clientThread);
                }
                catch (Exception ex)
                {
                    if(ex.HResult != -2146232800) //-2146232800 = Der Client wurde vor dem Login geschlossen, ignoriere Fehler
                    {
                        Console.WriteLine("Login fehlgeschlagen {0}", ex.Message);
                    }
                }
                
              
            
               
            }
        }

        /// <summary>
        /// Das Event, dass gefeuert wird, wenn ein Client die Verbindung verliert oder disconnected -> Er wird dann aus der threads Liste entfernt
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void ClientThread_ClientDisconnected(object sender, ClientEventArgs e)
        {
            threads.Remove(e.Client);
        }

        

        /// <summary>
        /// Prüfen ob der vom Server verwendete Port bereits verwendet wird
        /// </summary>
        /// <returns></returns>
        private static bool IsPortAvailable()
        {
            IPGlobalProperties ipProperties = IPGlobalProperties.GetIPGlobalProperties();
            IPEndPoint[] ipEndPoints = ipProperties.GetActiveTcpListeners();

            foreach (IPEndPoint endPoint in ipEndPoints)
            {

                if (endPoint.Port == _port)
                {
                    return false;
                }

            }
            return true;
        }

        private static bool HatNetzwerkKarte()
        {
            return System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable();
        }

    }
    /// <summary>
    /// Die EventArgs für Aktionen mit dem Serverthread, sodass man von außen auf den jeweiligen Thread zugreifen kann
    /// </summary>
    class ClientEventArgs : EventArgs
    {
        private ServerThread _client;
        private string _message;
        public ClientEventArgs(ServerThread client, string message)
        {
            this._client = client;
            this._message = message;
        }

        // Properties
        public ServerThread Client
        {
            get { return _client; }
        }

        public String Message
        {
            get { return _message; }
        }
    }

    delegate void ClientEventHandler(object sender, ClientEventArgs e);

    class ServerThread
    {
        //private byte Delimiter = 0x13;
        // Stop-Flag
        public bool stop = false;

        // Flag für "Thread läuft"
        public bool running = false;
        // Die Verbindung zum Client
        private TcpClient connection = null;
        
        public event ClientEventHandler ClientDisconnected;

        // Heartbeat
        public System.Timers.Timer heartbeatTimer;
        private bool receivedInTime = true; // Wird beim Empfang einer HeartbeatNachricht auf true gesetzt und beim senden einer auf False
        public TimeSpan heartbeatDifferenz = new TimeSpan(); // Die Differenz zwischen gesendet und empfangen des Heartbeats

        // Daten zur Verbindung
        public IPAddress IP = null;
        public string loginName = "";
        public String PC_NAME = "";
        public int VerbindungsID = 0; // Eindeutige ID der Verbindung
        private bool _connected = true; // Wenn eine neue Verbindung aufgebaut wird, ist diese standardmäßig aktiv

        Thread mainThread;

        // Speichert die Verbindung zum Client und startet den Thread
        public ServerThread(TcpClient connection)
        {
            // Speichert die Verbindung zu Client,
            // um sie später schließen zu können
            this.connection = connection;
            IP = ((IPEndPoint)connection.Client.RemoteEndPoint).Address;
            // Initialisiert und startet den Thread
            mainThread = new Thread(Run);
            mainThread.Start();

            // Heartbeat
            heartbeatTimer = new System.Timers.Timer(5000); // alle 30 Sekunden; Debug alle 5 sek
            heartbeatTimer.Elapsed += HeartbeatTimer_Elapsed;
            heartbeatTimer.Enabled = true;
        }

        private void HeartbeatTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            
            // Neuen Heartbeat senden
            if (receivedInTime)
            {
                receivedInTime = false;
                //Neuen Heartbeat senden
                TimeServerLibrary.HeartBeatNachricht heartBeatNachricht = new TimeServerLibrary.HeartBeatNachricht()
                {
                    gesendet = DateTime.Now
                };

                string heartBeat64 = TimeServerLibrary.NachrichtenSerializer.SerializeObject(heartBeatNachricht);
                this.Broadcast(Encoding.UTF8.GetBytes(heartBeat64));
            }
            else
            {
                OnClientDisconnected(new ClientEventArgs(this, "Client {0} hat nicht rechtzeitig geantwortet"));
            }
            
        }



        /// <summary>
        /// Das Event, wenn ein User disconnected oder die Verbindung verliert.
        /// </summary>
        /// <param name="e"></param>
        protected virtual void OnClientDisconnected(ClientEventArgs e)
        {
            Console.WriteLine(e.Message, IP);

            heartbeatTimer.Close();
            heartbeatTimer.Dispose();
            _connected = false;

            if (ClientDisconnected != null)
                ClientDisconnected(this, e);

            connection.Close();
        }

        /// <summary>
        /// Der eigentliche Thread -> Hier werden alle Daten des Clients empfangen. Sollte dabei die Verbindung beendet werden, dann wird der Client automatisch aus der Sendelsite entfernt.
        /// </summary>
        private void Run()
        {
            bool loop = true;
            while (connection.Connected && loop && _connected)
            {                
                List<byte> bytesReceived = new List<byte>();

     
                while (connection.Available > 0 && connection.Connected) // Läuft nur, wenn die Verbindung auch wirklich Daten sendet -> Wenn Verbindung abbricht, dann gibt es hier auch kein Fehler, da connection.available 0 bleibt
                {
                    NetworkStream inStream = connection.GetStream();
                    byte[] nextByte = new byte[1];
                    connection.Client.Receive(nextByte, 0, 1, SocketFlags.None);
                    bytesReceived.AddRange(nextByte);
                }
                
                    
                /* Alt
                // Reads NetworkStream into a byte buffer.
                //byte[] buffer = new byte[connection.ReceiveBufferSize];

                // Read can return anything from 0 to numBytesToRead. 
                // This method blocks until at least one byte is read.
                //int byte_count = inStream.Read(buffer, 0, (int)connection.ReceiveBufferSize); // Läuft die ganze Zeit, bis die Verbindung Daten sendet -> Wenn die Verbindung also abbricht, dann gibt es einen Fehler

                // Returns the data received from the host to the console.
                //byte[] formated = new Byte[byte_count];
                //Array.Copy(buffer, formated, byte_count); //handle  the null characteres in the byte array
                //formated = Convert.FromBase64String(Encoding.UTF8.GetString(formated)); // Wir dekodieren den Base64 String wieder zu einem ByteArray
                */

                string data = System.Text.Encoding.UTF8.GetString(bytesReceived.ToArray());

                if (!string.IsNullOrWhiteSpace(data))
                {
                    object nachricht = TimeServerLibrary.NachrichtenSerializer.DeserializeObject(data);

                    if(nachricht.GetType() == typeof(TimeServerLibrary.LoginNachricht))
                    {
                        TimeServerLibrary.LoginNachricht loginNachricht = nachricht as TimeServerLibrary.LoginNachricht;
                        this.loginName = loginNachricht.LOGIN_NAME;
                        this.PC_NAME = loginNachricht.PC_NAME;

                        Console.WriteLine("{0} hat sich verbunden - PC-NAME: {1}", loginName, PC_NAME);

                        // Informiere andere User über den Login
                        TimeServerLibrary.PublicNachricht publicNachricht = new TimeServerLibrary.PublicNachricht()
                        {
                            nachricht = loginName + " hat den Chat betreten.",
                            fontColor = ConsoleColor.Yellow
                        };

                        
                        Program.SendMessage(publicNachricht);
                    }
                    else if (nachricht.GetType() == typeof(TimeServerLibrary.PublicNachricht)) // Nachricht im Hauptraum!
                    {
                        TimeServerLibrary.PublicNachricht publicNachricht = nachricht as TimeServerLibrary.PublicNachricht;
                        publicNachricht.VERSENDER_ID = VerbindungsID;
                        Program.SendMessage(publicNachricht);
                    }
                    else if (nachricht.GetType() == typeof(TimeServerLibrary.PrivateNachricht))// Privat Nachricht, weiterleiten an Client
                    {
                        TimeServerLibrary.PrivateNachricht privateNachricht = nachricht as TimeServerLibrary.PrivateNachricht;
                        privateNachricht.VERSENDER_ID = VerbindungsID;

                        if (!Program.SendMessage(privateNachricht, privateNachricht.Empfänger_ID))
                        {
                            privateNachricht.Empfänger_ID = VerbindungsID;
                            privateNachricht.VERSENDER_NAME = "[SERVER]";
                            privateNachricht.Nachricht = "Der Empfänger konnte nicht gefunden werden!";
                            Program.SendMessage(privateNachricht, VerbindungsID);
                        }

                    }
                    else if (nachricht.GetType() == typeof(TimeServerLibrary.HeartBeatNachricht))// Heartbeat Message
                    {
                        DateTime gesendet = ((TimeServerLibrary.HeartBeatNachricht)nachricht).gesendet; // Die DateTime, als die Nachricht vom Server an den Client geschickt wurde
                        DateTime empfangen = ((TimeServerLibrary.HeartBeatNachricht)nachricht).empfangen; // Die DateTime, als die Nachricht vom Server beim Client angekommen ist
                        heartbeatDifferenz = empfangen - gesendet;
                        receivedInTime = true;
                        Console.WriteLine("Verbindung {0} Differenz {1}", VerbindungsID, heartbeatDifferenz);
                    }
                    else // Uns erreicht eine Disconnect-Meldung
                    {
                        ((TimeServerLibrary.DisconnectNachricht)nachricht).Username = loginName;
                        OnClientDisconnected(new ClientEventArgs(this, IP + " " + ((TimeServerLibrary.DisconnectNachricht)nachricht).Nachricht));
                        Program.SendMessage(nachricht); // Teile allen verfügbaren Clienten den Disconnect mit
                    }

                    // Wiederhole die Schleife so lange bis von außen der Stopwunsch kommt
                    loop = !this.stop;
                }
            }
            if (!stop) // Bei Stop wird die Verbindung erzwungen beendet
            {
                OnClientDisconnected(new ClientEventArgs(this, "Client {0} hat die Verbindung getrennt."));
            }
        }

        /// <summary>
        /// Sende beliebige Daten
        /// </summary>
        /// <param name="data"></param>
        public void Broadcast(byte[] data)
        {
            try
            {
                connection.GetStream().Write(data, 0, data.Length);
            }
            catch (IOException ex)
            {
                if(ex.HResult != -2146232800) // -2146232800 ist die Fehlermeldung, wenn die Verbindungs vom Remotehoste geschlossen wurde
                {
                    Console.WriteLine(ex.Message);
                }
                
                OnClientDisconnected(new ClientEventArgs(this, IP + " hat die Verbindung verloren..."));
                stop = true;
            }
            
        }

   


       
        /// <summary>
        /// Kickt den Clienten vom Server
        /// </summary>
        public void Kick()
        {
            //string nachricht64 = TimeServerLibrary.NachrichtenSerializer.SerializeObject(new TimeServerLibrary.KickNachricht());
            TimeServerLibrary.KickNachricht kickNachricht = new TimeServerLibrary.KickNachricht();
            Program.SendMessage(kickNachricht, VerbindungsID);
            OnClientDisconnected(new ClientEventArgs(this, IP + " wurde vom Server gekickt."));
        }
    }
}
